clear all

addpath(genpath(pwd))

rv=[20,20,3];

c=0.2;

var=0.5;

p=0.3;

for nn=2
    
    disp(nn)
    
    I=imread(['2kimage\' num2str(nn) '.png']);

    X=double(I)/255;

    n_t=size(X);
    
    N=ndims(X);
    
    if nn<6
    
        G=noisemix(numel(X),1,c,0.001,var,'gaussian');
        X_n=X+reshape(G,size(X));
        X_n(X_n>1)=1;
        X_n(X_n<0)=0;
    
    elseif nn>=6&&nn<11
        
        X_n=imnoise(X,'salt & pepper', c);
        
    elseif nn>=11
        
        indx=randperm(numel(X),floor(c*numel(X)));
        X_n=X;
        X_n(indx)=rand(floor(c*numel(X)),1);
        
    end   

    option.r=rv; 
    option.I=X;
    option.maxitr=30;
    option.stopc=1e-3;
    option.sample_num=30000;
    option.embedding_dims=[400,400,3];
    option.yita = 4; %huber2
    option.sigmamin = 0.15; %huber0.05
    option.estimator = 'cauchy';
    
    Mask=ones(size(X));
    indx=randperm(numel(X),floor((1-p)*numel(X)));
    Mask(indx)=0;
    
    MissM=X_n.*Mask;
    
    MissM3=reshape(MissM,n_t(1),n_t(2),[]);
    Mask3=reshape(Mask,n_t(1),n_t(2),[]);

    N=ndims(X);

    time=[];
    PSNR_all=[];
    frame=1;
    opt.framenum=frame;

    opt.p=p;
    opt.I=X;

    %% SAWRTRD
    t1=tic;
    [Z,option.sample_num_multi,~]=SAWRTRD(MissM,Mask,option);
    time=[time toc(t1)];
    TCP2=TCP(Z(2:end));
    I_SAWRTRD=reshape(T2M_n(Z{1})*T2M_r(TCP2,2)',size(X));
    disp(['SAWRTRD : ' num2str(psnr(I_SAWRTRD,X)) ' , time : ' num2str(time(end))])
    PSNR_all=[PSNR_all psnr(I_SAWRTRD,X)];

    %% AWRTRD
    t1=tic;
    Z=AWRTRD(MissM,Mask,option);
    time=[time toc(t1)];
    TCP2=TCP(Z(2:end));
    I_AWRTRD=reshape(T2M_n(Z{1})*T2M_r(TCP2,2)',size(X));
    disp(['AWRTRD : ' num2str(psnr(I_AWRTRD,X)) ' , time : ' num2str(time(end))])
    PSNR_all=[PSNR_all psnr(I_AWRTRD,X)];
            
    %% TRNN_L1
    option=get_option_default(MissM,'TRNN_L1',opt);
    t1=tic;
    M=TRNN_L1_official(MissM,Mask,option,I);
    I_TRNN_L1=reshape(M,n_t);
    time=[time toc(t1)];
    disp(['TRNN_L1 : ' num2str(psnr(I_TRNN_L1,X)) ' , time : ' num2str(time(end))])
    PSNR_all=[PSNR_all psnr(I_TRNN_L1,X)];

    %% TNN_L1
    option=get_option_default(MissM3,'TNN_L1',opt);
    t1=tic;
    [M,E]=TNN_L1(MissM3,Mask3,option,I);
    I_TNN_L1=reshape(M,n_t);
    time=[time toc(t1)];
    disp(['TNN_L1 : ' num2str(psnr(I_TNN_L1,X)) ' , time : ' num2str(time(end))])
    PSNR_all=[PSNR_all psnr(I_TNN_L1,X)];

    %% SNN_L1
    t1=tic;
    option=get_option_default(MissM3,'SNN_L1',opt);
    M = SNN_L1(MissM3,Mask3,I,option);
    I_SNN_L1=reshape(M.data,n_t);
    time=[time toc(t1)];
    disp(['SNN_L1 : ' num2str(psnr(I_SNN_L1,X)) ' , time : ' num2str(time(end))])
    PSNR_all=[PSNR_all psnr(I_SNN_L1,X)];

    %% lp-TRC
    t1=tic;
    option=get_option_default(MissM3,'SNN_WST',opt);
    M= SNN_WST(MissM3,Mask3,I,option);
    I_SNN_WST=reshape(M,n_t);
    time=[time toc(t1)];
    disp(['SNN_WST : ' num2str(psnr(I_SNN_WST,X)) ' , time : ' num2str(time(end))])
    PSNR_all=[PSNR_all psnr(I_SNN_WST,X)];

    %% TNTV
    option=get_option_default(MissM3,'TNTV',opt);
    option.lambda = 6/sqrt(opt.p*size(MissM,3)*max(size(MissM,1),size(MissM,2)));
    t1=tic;
    Ld = LowSparNDCT(MissM3, Mask3, option);
    option.rho = 1000;
    O = Unfoldtntv(Ld,size(MissM3),3);
    [U,~,~] = svd(O,'econ');
    Lu = LowSparNU(U, MissM3, Mask3, option);
    I_TNTV=reshape(Lu,n_t);
    time=[time toc(t1)];
    disp(['TNTV : ' num2str(psnr(I_TNTV,X)) ' , time : ' num2str(time(end))])
    PSNR_all=[PSNR_all psnr(I_TNTV,X)];

end


