clear

addpath(genpath(pwd))

video_name='flamingo';%'kite-surf';%breakdance %flamingo
SamplePath1 =  ['data\' video_name '\'];  
fileExt = '*.jpg';  

files = dir(fullfile(SamplePath1,fileExt)); 

frame = 50;
opt.framenum=frame;

p=0.3;
c=0.2;
%遍历路径下每一幅图像
X=[];
for i=1:1:frame
   fileName = strcat(SamplePath1,files(i).name); 
   image = imread(fileName);
   X(:,:,:,i) = image;
end

X=double(X)/255;

n_I=size(X);

rv=[80,80,3,20];

opt.p=p;
opt.I=X;

G=noisemix(numel(X),1,c,0.001,0.5,'gaussian');
X_n=X+reshape(G,size(X));
X_n(X_n>1)=1;
X_n(X_n<0)=0;

Mask=ones(size(X));
indx=randperm(numel(X),floor((1-p)*numel(X)));
Mask(indx)=0;

MissM=X_n.*Mask;

N=ndims(X);


for nn=50000%:10000:100000%[14000:2000:20000 30000:10000:50000]
    
    nn
    
    time=[];
    
    option=get_option_default(MissM,'AWRTRD',opt);
    option.r=rv;
    option.sample_num=nn;

    %% original
    tic
    [Z1,option.sample_num_multi]=SAWRTRD(MissM,Mask,option);
    toc
    time=[time toc];

    %% original
    tic
    Z2=SAWRTRD_row(MissM,Mask,option);
    toc
    time=[time toc];
    
    %% original
    tic
    Z3=SAWRTRD_row(MissM,Mask,option,'uniform_sampling',true);
    toc
    time=[time toc];

    %% local
    tic
    Z4=SAWRTRD_local(MissM,Mask,option);
    toc
    time=[time toc];
     
    %% SD
    tic
    [Z7,option.sample_num_multi]=SAWRTRD_gradient(MissM,Mask,option);
    toc
    time=[time toc];
    
    %save(['results\revise_sample_num_' num2str(nn) '.mat'])

end


