function [tt]=tt_qshift(d,m)

% for integer m
% returns the non-periodic downward m-position shift matrix of size 2^d x 2^d,
% in the QTT format
% The shift is (-m)-position upward for m < 0
% m=0 corresponds to the identity matrix
% m=2^d corresponds to the zero matrix
% m=-2^d corresponds to the zero matrix
%
% January 25, 2011
% Vladimir Kazeev
% vladimir.kazeev@gmail.com
% INM RAS
% Moscow, Russia
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% For details please see the preprint
% http://www.mis.mpg.de/publications/preprints/2011/prepr2011-36.html
% Vladimir A. Kazeev, Boris N. Khoromskij and Eugene E. Tyrtyshnikov
% Multilevel Toeplitz matrices generated by QTT tensor-structured vectors and convolution with logarithmic complexity
% January 12, 2012
% Vladimir Kazeev,
% Seminar for Applied Mathematics, ETH Zurich
% vladimir.kazeev@sam.math.ethz.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

I=eye(2);
J=[0,1;0,0];
O=zeros(2);

tt=cell(d,1);

if (m < 0)
	J=J';
	m=abs(m);
end
if (abs(m) >= 2^d)
	for k=1:d
		tt{k}=O;
	end
	return
end

m=dec2bin(m,d);

if (m(1) == '1')
	tt{1}=[J',O];
else
	tt{1}=[I,J'];
end
tt{1}=reshape(tt{1},[2,2,2]);

for k=2:d-1
	if (m(k) == '1')
		tt{k}=[J',O;J,I];
	else
		tt{k}=[I,J';O,J];
	end
	tt{k}=permute(reshape(tt{k},[2,2,2,2]),[1,3,2,4]);
end

if (m(d) == '1')
	tt{d}=[J',J];
else
	tt{d}=[I,O];
end
tt{d}=reshape(tt{d},[2,2,2]);

tt=tt_reverse(tt,2);

return
end