clear all

addpath(genpath(pwd))

rv=[80,80,3,20];

c=0.2;

var=0.5;

for nn=3
    
    disp(nn)
    
    SamplePath1 =  ['data\videodata\' num2str(nn) '\'];  
    fileExt = '*.jpg';  

    files = dir(fullfile(SamplePath1,fileExt)); 

    frame = min(length(files),50);
    %遍历路径下每一幅图像
    X=[];
    for i=1:1:frame
       fileName = strcat(SamplePath1,files(i).name); 
       image = imread(fileName);
       X(:,:,:,i) = image;
    end

    X=double(X)/255;

    n_t=size(X);
    
    N=ndims(X);
  
    if nn<6
    
        G=noisemix(numel(X),1,c,0.001,var,'gaussian');
        X_n=X+reshape(G,size(X));
        X_n(X_n>1)=1;
        X_n(X_n<0)=0;
    
    elseif nn>=6&&nn<11
        
        X_n=imnoise(X,'salt & pepper', c);
        
    elseif nn>=11
        
        indx=randperm(numel(X),floor(c*numel(X)));
        X_n=X;
        X_n(indx)=rand(floor(c*numel(X)),1);
        clear indx
        
    end   

    option.r=rv; 
    option.I=X;
    option.maxitr=30;
    option.stopc=1e-3;
    option.sample_num=30000;
    option.embedding_dims=[200,200,3,10];
    option.yita = 4; %huber2
    option.sigmamin = 0.15; %huber0.05
    option.estimator = 'cauchy';

    time=[];
    PSNR=[];
    Mask=ones(n_t);
    clear G
    
    %% SAWRTRD    
    t1=tic;
    [Z,option.sample_num_multi,~]=SAWRTRD(X_n,Mask,option);
    time=[time toc(t1)];
    clear Mask
    TCP2=TCP(Z(2:end));
    I_SAWRTRD=reshape(T2M_n(Z{1})*T2M_r(TCP2,2)',size(X));
    PSNR=[PSNR psnr(X,I_SAWRTRD)];
    disp(['SAWRTRD : ' num2str(psnr(I_SAWRTRD,X)) ' , time : ' num2str(time(end))])
     
    %% TR-ALS-S
    J=option.sample_num_multi;
    t1=tic;
    Z = tr_als_sampled(X_n, rv, J, X, 'tol', option.stopc, 'maxiters', option.maxitr, 'resample', true, 'verbose', false); 
    time=[time toc(t1)];
    TCP2=TCP(Z(2:end));
    I_TRALS_S=reshape(T2M_n(Z{1})*T2M_r(TCP2,2)',size(X));
    PSNR=[PSNR psnr(X,I_TRALS_S)];
    disp(['TR-ALS-S : ' num2str(psnr(I_TRALS_S,X)) ' , time : ' num2str(time(end))])

    %% rTR-ALS
    t1=tic;
    Z= rtr_als(X_n, rv, option.embedding_dims, 'tol', option.stopc, 'maxiters', option.maxitr, 'verbose', false); 
    time=[time toc(t1)];
    TCP2=TCP(Z(2:end));
    I_rTRALS=reshape(T2M_n(Z{1})*T2M_r(TCP2,2)',size(X));
    PSNR=[PSNR psnr(X,I_rTRALS)];
    disp(['rTR-ALS : ' num2str(psnr(I_rTRALS,X)) ' , time : ' num2str(time(end))])
    
    %% TR-SVD-Rand
    oversamp=200;
    t1=tic;
    Z = tr_svd_rand(X_n, rv, oversamp);
    time=[time toc(t1)];
    TCP2=TCP(Z(2:end));
    I_trsvd_rand=reshape(T2M_n(Z{1})*T2M_r(TCP2,2)',size(X));
    PSNR=[PSNR psnr(X,I_trsvd_rand)];
    disp(['TR-SVD-Rand : ' num2str(psnr(I_trsvd_rand,X)) ' , time : ' num2str(time(end))])

%     %% TR-ALS
%     t1=tic;
%     Z= tr_als(X_n, rv, 'maxiters', option.maxitr, 'tol', option.stopc, 'verbose', false); 
%     time=[time toc(t1)];
%     TCP2=TCP(Z(2:end));
%     I_TRALS=reshape(T2M_n(Z{1})*T2M_r(TCP2,2)',size(X));
%     PSNR=[PSNR psnr(X,I_TRALS)];
%     disp(['TR-ALS : ' num2str(psnr(I_TRALS,X)) ' , time : ' num2str(time(end))])
    
   %% TR-SVD
    t1=tic;
    Z = TRdecomp_ranks(X_n, [80 80 20 20]);
    time=[time toc(t1)];
    TCP2=TCP(Z(2:end));
    I_trsvd=reshape(T2M_n(Z{1})*T2M_r(TCP2,2)',size(X));
    PSNR=[PSNR psnr(X,I_trsvd)];
    disp(['TR-SVD : ' num2str(psnr(I_trsvd,X)) ' , time : ' num2str(time(end))])

%    %% AWRTRD
%     t1=tic;
%     Z=AWRTRD(X_n,Mask,option);
%     time=[time toc(t1)];
%     TCP2=TCP(Z(2:end));
%     I_AWRTRD=reshape(T2M_n(Z{1})*T2M_r(TCP2,2)',size(X));
%     PSNR=[PSNR psnr(X,I_AWRTRD)];
%     disp(['AWRTRD : ' num2str(psnr(I_AWRTRD,X)) ' , time : ' num2str(time(end))])

    save(['results\video_decomp_' num2str(nn) '_example.mat']);%,'PSNR','time');
    
    clear TCP2 I_rTRALS I_SAWRTRD I_TRALS_S I_trsvd I_trsvd_rand Z

end


