% @KTENSOR
%
% Files
%   arrange     - Arranges the rank-1 components of a ktensor.
%   datadisp    - Special display of a ktensor.
%   disp        - Command window display for a ktensor.
%   display     - Command window display for a ktensor.
%   double      - Convert a ktensor to a double array.
%   end         - Last index of indexing expression for ktensor.
%   extract     - Creates a new ktensor with only the specified components.
%   fixsigns    - Fix sign ambiguity of a ktensor.
%   full        - Convert a ktensor to a (dense) tensor.
%   innerprod   - Efficient inner product with a ktensor.
%   ktensor     - Tensor stored as a Kruskal operator (decomposed).
%   minus       - Binary subtraction for ktensor.  
%   mtimes      - Implement A*B (scalar multiply) for ktensor.
%   mttkrp      - Matricized tensor times Khatri-Rao product for ktensor.
%   ncomponents - Number of components for a ktensor.
%   ndims       - Number of dimensions for a ktensor.
%   norm        - Frobenius norm of a ktensor.
%   normalize   - Normalizes the columns of the factor matrices.
%   nvecs       - Compute the leading mode-n vectors for a ktensor.
%   permute     - Permute dimensions of a ktensor.
%   plus        - Binary addition for ktensor.
%   size        - Size of ktensor.
%   subsasgn    - Subscripted assignement for ktensor.
%   subsref     - Subscripted reference for a ktensor.
%   times       - Element-wise multiplication for ktensor.
%   tocell      - Convert X to a cell array.
%   ttm         - Tensor times matrix for ktensor.
%   ttv         - Tensor times vector for ktensor.
%   uminus      - Unary minus for ktensor. 
%   uplus       - Unary plus for a ktensor. 
