from typing import Tuple

from pydantic import BaseModel

from llm_mcts.data_types import ACTIONS, Action


class MCTSConfig(BaseModel):
    num_simulations: int = 5
    num_expand_samples: int | None = None
    initial_expand_samples: int | None = None

    actions: Tuple[Action, ...] = ACTIONS

    alpha: float = 0.5
