from llm_mcts.prompt_configs import PromptConfig
from llm_mcts.prompts.arc.baseline_v1_single_turn import BaselineV1PromptSingleTurn
from llm_mcts.prompts.code_contest.baseline import CodeContestBaselinePrompt
from llm_mcts.prompts.code_contest.cot_v5 import CodeContestCOTV5Prompt
from llm_mcts.prompts.code_contest.cot_v5_single_turn import (
    CodeContestCOTV5SingleTurnPrompt,
)
from llm_mcts.prompts.code_contest.lcb_single_turn import CodeContestLCBSingleTurnPrompt
from llm_mcts.prompts.live_code_bench_code_generation.live_code_bench import (
    LiveCodeBenchPrompt as LiveCodeBenchCodeGenerationPrompt,
)
from llm_mcts.prompts.live_code_bench_code_generation.live_code_bench_v10 import (
    LiveCodeBenchPromptV10 as LiveCodeBenchCodeGenerationPromptV10,
)
from llm_mcts.prompts.live_code_bench_code_generation.live_code_bench_v10_single_turn import (
    LiveCodeBenchPromptV10SingleTurn as LiveCodeBenchCodeGenerationPromptV10SingleTurn,
)
from llm_mcts.prompts.base import PromptTemplate
from llm_mcts.tasks.arc.task import ARCProblem
from llm_mcts.tasks.code_contest.task import CodeContestTask
from llm_mcts.tasks.live_code_bench_code_generation.task import (
    LiveCodeBenchCodeGenerationTask,
)
from llm_mcts.tasks.base import Task


def build_prompt_template(prompt_config: PromptConfig, task: Task) -> PromptTemplate:
    if isinstance(task, ARCProblem):
        if prompt_config.initial_prompt_type == "baseline_v1_single_turn":
            return BaselineV1PromptSingleTurn(prompt_config=prompt_config, problem=task)
        else:
            raise NotImplementedError(
                f"initial_prompt type {prompt_config.initial_prompt_type} not implemented"
            )
    elif isinstance(task, CodeContestTask):
        if prompt_config.initial_prompt_type == "code_contest_baseline":
            return CodeContestBaselinePrompt(prompt_config=prompt_config, task=task)
        elif prompt_config.initial_prompt_type == "code_contest_cot_v5":
            return CodeContestCOTV5Prompt(prompt_config=prompt_config, task=task)
        elif prompt_config.initial_prompt_type == "code_contest_cot_v5_single_turn":
            return CodeContestCOTV5SingleTurnPrompt(
                prompt_config=prompt_config, task=task
            )
        elif prompt_config.initial_prompt_type == "code_contest_lcb_single_turn":
            return CodeContestLCBSingleTurnPrompt(
                prompt_config=prompt_config, task=task
            )
        else:
            raise NotImplementedError(
                f"initial_prompt type {prompt_config.initial_prompt_type} not implemented"
            )
    elif isinstance(task, LiveCodeBenchCodeGenerationTask):
        if prompt_config.initial_prompt_type == "live_code_bench_code_generation":
            return LiveCodeBenchCodeGenerationPrompt(
                prompt_config=prompt_config, task=task
            )
        elif prompt_config.initial_prompt_type == "live_code_bench_code_generation_v10":
            return LiveCodeBenchCodeGenerationPromptV10(
                prompt_config=prompt_config, task=task
            )
        elif (
            prompt_config.initial_prompt_type
            == "live_code_bench_code_generation_v10_single_turn"
        ):
            return LiveCodeBenchCodeGenerationPromptV10SingleTurn(
                prompt_config=prompt_config, task=task
            )
        else:
            raise NotImplementedError(
                f"initial_prompt type {prompt_config.initial_prompt_type} not implemented"
            )
    else:
        raise NotImplementedError(
            f"build_prompt_template for task {task} not implemented"
        )
