#!/bin/bash
#SBATCH --job-name="llm-mcts-mathvista"
#SBATCH --time=36:00:00
#SBATCH --partition=cpu
#SBATCH --cpus-per-task=4
#SBATCH --gres=gpu:0
#SBATCH --mem=8G
#SBATCH --output=/home/%u/sbatch-outputs/%x/%A/%a.out
#SBATCH --error=/home/%u/sbatch-outputs/%x/%A/%a.out
#SBATCH --array=0-999%4

# NOTE: change the below to your own directory
cd /path/to/llm-mcts

# NOTE: change the below to your own virtual environment (if you need)
source ./venv/bin/activate

# NOTE: you need to have a .env file in the root directory
if [ -f .env ]; then
  set -a
  source .env
  set +a
else
  echo ".env file not found!"
  exit 1
fi

# Process
echo "SLURM_ARRAY_TASK_ID: $SLURM_ARRAY_TASK_ID"
PYTHONPATH="$PYTHONPATH:.." python scripts/math_vista/run_math_vista.py --experiment_name gpt4o20240806-ns1-ne1-t0 --idx $SLURM_ARRAY_TASK_ID \
  --answer_model gpt-4o-2024-08-06 --temperature 0.0 --num_simulations 1 --num_expand_samples 1 \
  --judge_model gpt-4o-2024-08-06 --judge_temperature 0.0
PYTHONPATH="$PYTHONPATH:.." python scripts/math_vista/evaluate_math_vista.py --experiment_name gpt4o20240806-ns1-ne1-t0 --idx $SLURM_ARRAY_TASK_ID \
  --judge_model gpt-4o-2024-08-06 --judge_temperature 0.0
