#!/bin/bash

INITIAL_EXPAND_SAMPLES=$1

if [ "$INITIAL_EXPAND_SAMPLES" -eq 1 ]; then
    TEMPERATURE="0.0"
else
    TEMPERATURE="0.6"
fi

ANSWER_MODELS="gpt-4o-2024-08-06"
MODEL_PROBS="1"
NUM_SIMULATIONS=0
NUM_EXPAND_SAMPLES=0
# INITIAL_EXPAND_SAMPLES=1
SPLIT="test"
N_JOBS=32  # 推論時に同時に実行するジョブ数
N_WORKERS=32  # 評価時に同時に実行するワーカー数
START_IDX=0
END_IDX=164
MCTS_ALGO="standard"
PROMPT_TYPE="code_contest_cot_v5"

EXPERIMENT_NAME="exp002_${ANSWER_MODELS}_${MCTS_ALGO}_nsim${NUM_SIMULATIONS}_${PROMPT_TYPE}_resample${INITIAL_EXPAND_SAMPLES}"


start_time=$(date +%s)
seq $START_IDX $END_IDX | parallel -j $N_JOBS \
    python scripts/code_contest/run_code_contest.py \
    --experiment_name $EXPERIMENT_NAME \
    --idx {} \
    --split $SPLIT \
    --answer_models $ANSWER_MODELS \
    --answer_model_probs $MODEL_PROBS \
    --temperature $TEMPERATURE \
    --num_simulations $NUM_SIMULATIONS \
    --num_expand_samples $NUM_EXPAND_SAMPLES \
    --initial_prompt_type $PROMPT_TYPE \
    --initial_expand_samples $INITIAL_EXPAND_SAMPLES \
    --mcts_algo $MCTS_ALGO
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
elapsed_time=$(echo "scale=2; $elapsed_time / 60" | bc)
echo "Elapsed time (run): $elapsed_time minutes"

start_time=$(date +%s)
for IDX in $(seq $START_IDX $END_IDX); do \
    python scripts/code_contest/evaluate_code_contest.py \
    --experiment_name $EXPERIMENT_NAME \
    --idx $IDX \
    --split $SPLIT \
    --num_workers $N_WORKERS
done
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
elapsed_time=$(echo "scale=2; $elapsed_time / 60" | bc)
echo "Elapsed time (evaluate): $elapsed_time minutes"

start_time=$(date +%s)
seq $START_IDX $END_IDX | parallel -j $N_JOBS \
    python scripts/code_contest/make_submission_code_contest.py \
    --experiment_name $EXPERIMENT_NAME \
    --idx {} \
    --split $SPLIT
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
elapsed_time=$(echo "scale=2; $elapsed_time / 60" | bc)
echo "Elapsed time (make submission): $elapsed_time minutes"

python scripts/code_contest/gather_results_code_contest.py \
    --experiment_name $EXPERIMENT_NAME
