#!/bin/bash

ANSWER_MODELS="gpt-4o-2024-08-06"
MODEL_PROBS="1"
TEMPERATURE="0.6"
NUM_SIMULATIONS=9
NUM_EXPAND_SAMPLES=1
INITIAL_EXPAND_SAMPLES=1
SPLIT="test"
N_JOBS=30  # 同時に実行するジョブ数
START_IDX=0
END_IDX=164
MCTS_ALGO="linucb"

EXPERIMENT_NAME="${ANSWER_MODELS}_linucb_nsim${NUM_SIMULATIONS}"

start_time=$(date +%s)
seq $START_IDX $END_IDX | PYTHONPATH=".:$PYTHONPATH" parallel -j $N_JOBS \
    python scripts/code_contest/run_code_contest.py \
    --experiment_name $EXPERIMENT_NAME \
    --idx {} \
    --split $SPLIT \
    --answer_models $ANSWER_MODELS \
    --answer_model_probs $MODEL_PROBS \
    --temperature $TEMPERATURE \
    --num_simulations $NUM_SIMULATIONS \
    --num_expand_samples $NUM_EXPAND_SAMPLES \
    --initial_expand_samples $INITIAL_EXPAND_SAMPLES \
    --mcts_algo $MCTS_ALGO

end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
elapsed_time=$(echo "scale=2; $elapsed_time / 60" | bc)
echo "Elapsed time (run): $elapsed_time minutes"

start_time=$(date +%s)
seq $START_IDX $END_IDX | PYTHONPATH=".:$PYTHONPATH" parallel -j $N_JOBS \
    python scripts/code_contest/evaluate_code_contest.py \
    --experiment_name $EXPERIMENT_NAME \
    --idx {} \
    --split $SPLIT
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
elapsed_time=$(echo "scale=2; $elapsed_time / 60" | bc)
echo "Elapsed time (evaluate): $elapsed_time minutes"

start_time=$(date +%s)
seq $START_IDX $END_IDX | PYTHONPATH=".:$PYTHONPATH" parallel -j $N_JOBS \
    python scripts/code_contest/make_submission_code_contest.py \
    --experiment_name $EXPERIMENT_NAME \
    --idx {} \
    --split $SPLIT
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
elapsed_time=$(echo "scale=2; $elapsed_time / 60" | bc)
echo "Elapsed time (make submission): $elapsed_time minutes"

python scripts/code_contest/gather_results_code_contest.py \
    --experiment_name $EXPERIMENT_NAME

