#!/bin/bash

ANSWER_MODELS="gpt-4o-2024-08-06"
TEMPERATURE="0.6"
NUM_SIMULATIONS=15
SPLIT="testmini"

MCTS_ALGO="thompson"

EXPERIMENT_NAME="debug_${ANSWER_MODELS}_${MCTS_ALGO}_nsim${NUM_SIMULATIONS}"

start_time=$(date +%s)
python scripts/math_vista/run_math_vista.py \
    --experiment_name $EXPERIMENT_NAME \
    --idx 0 \
    --split $SPLIT \
    --answer_models $ANSWER_MODELS \
    --answer_temperatures $TEMPERATURE \
    --mcts_algo $MCTS_ALGO \
    --num_simulations $NUM_SIMULATIONS
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
elapsed_time=$(echo "scale=2; $elapsed_time / 60" | bc)
echo "Elapsed time (run): $elapsed_time minutes"

start_time=$(date +%s)
python scripts/math_vista/evaluate_math_vista.py \
    --experiment_name $EXPERIMENT_NAME \
    --idx 0 \
    --split $SPLIT
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
elapsed_time=$(echo "scale=2; $elapsed_time / 60" | bc)
echo "Elapsed time (evaluate): $elapsed_time minutes"
