#!/bin/bash

ANSWER_MODELS="gpt-4o-2024-08-06"
MODEL_PROBS="1"
TEMPERATURE="0.6"
NUM_SIMULATIONS=3  # Correspond to `t`
NUM_EXPAND_SAMPLES=2  # Correspond to `b`
INITIAL_EXPAND_SAMPLES=4  # Correspond to `k`
SPLIT="testmini"

MCTS_ALGO="tot-bfs"

EXPERIMENT_NAME="debug_${ANSWER_MODELS}_${MCTS_ALGO}_t${NUM_SIMULATIONS}_k${INITIAL_EXPAND_SAMPLES}_b${NUM_EXPAND_SAMPLES}"

start_time=$(date +%s)
python scripts/math_vista/run_math_vista.py \
    --experiment_name $EXPERIMENT_NAME \
    --idx 0 \
    --split $SPLIT \
    --answer_models $ANSWER_MODELS \
    --answer_model_probs $MODEL_PROBS \
    --answer_temperatures $TEMPERATURE \
    --mcts_algo $MCTS_ALGO \
    --num_simulations $NUM_SIMULATIONS \
    --num_expand_samples $NUM_EXPAND_SAMPLES \
    --initial_expand_samples $INITIAL_EXPAND_SAMPLES
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
elapsed_time=$(echo "scale=2; $elapsed_time / 60" | bc)
echo "Elapsed time (run): $elapsed_time minutes"

start_time=$(date +%s)
python scripts/math_vista/evaluate_math_vista.py \
    --experiment_name $EXPERIMENT_NAME \
    --idx 0 \
    --split $SPLIT
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
elapsed_time=$(echo "scale=2; $elapsed_time / 60" | bc)
echo "Elapsed time (evaluate): $elapsed_time minutes"
