from typing import Dict, List, Set, Tuple


class ThompsonNodeIndices:
    """
    Node Index handler, responsible for adding and retrieving node information
    """

    def __init__(self, model_names: List[str]):
        self.indices: Dict[Tuple[int, str], Set[int]] = {
            (model_idx, model): set() for model_idx, model in enumerate(model_names)
        }
        self.next_idx: int = 0

    def add_new_node(self, model_name: str) -> int:
        for idx, model in self.indices:
            if model_name == model:
                self.indices[(idx, model)].add(self.next_idx)
                self.next_idx += 1
                return self.next_idx - 1

        raise RuntimeError(f"model_name {model_name} invalid.")

    def get_model_name(self, node_idx: int) -> str:
        for (_, model_name), idxs in self.indices.items():
            if node_idx in idxs:
                return model_name

        raise RuntimeError(
            f"node_idx {node_idx} out of bounds for node indices {self.indices}"
        )
