from dataclasses import dataclass
from typing import Dict, List


@dataclass
class CodeContestProblem:
    name: str
    description: str
    public_tests: Dict[str, List[str]]
    private_tests: Dict[str, List[str]]
    generated_tests: Dict[str, List[str]]
    source: int
    difficulty: int
    solutions: Dict[str, int | str]
    incorrect_solutions: Dict[str, int | str]
    cf_contest_id: int
    cf_index: str
    cf_points: float
    cf_rating: int
    cf_tags: List[str]
    is_description_translated: bool
    untranslated_description: str
    time_limit: Dict[str, int]
    memory_limit_bytes: int
    input_file: str
    output_file: str
