# Overview

## Description

The [Metropolitan Museum of Art](https://www.metmuseum.org/) in New York, also known as The Met, has a diverse collection of over 1.5M objects of which over 200K have been digitized with imagery. Can you help find the significant attributes to identify a specific work of art? Help advance this research in this notebook competition.

The online cataloguing information is generated by subject matter experts and includes a wide range of data. These include, but are not limited to: multiple object classifications, artist, title, period, date, medium, culture, size, provenance, geographic location, and other related museum objects within The Met’s collection. While the annotations describe the object from an art history perspective, they can also be indirect in describing finer-grained attributes for the museum-goer’s understanding. Adding fine-grained attributes to aid in the visual understanding of the museum objects will enable the ability to search for visually related objects.

> This is a Code Competition. Refer to Code Requirements for details.

### About

This is an FGVCx competition hosted as part of the [FGVC7 workshop](https://sites.google.com/view/fgvc7/home) at [CVPR 2020](http://cvpr2020.thecvf.com/).

## Evaluation

Submissions will be evaluated based on their micro averaged [F1 score](https://en.wikipedia.org/wiki/F1_score).

### Submission File

```
id,attribute_ids
00011f01965f141f5d1eea6592fa9862,0 1 2
00014abc91ed3e4bf1663fde8136fe80,0 1 2
0002e2054e303badc1a33463f6fb7973,0 1 2
```

## Timeline

- **May 21, 2020** - Entry deadline. You must accept the competition rules before this date in order to compete.
- **May 21, 2020** - Team Merger deadline. This is the last day participants may join or merge teams.
- **May 28, 2020** - Final submission deadline.

All deadlines are at 11:59 PM UTC on the corresponding day unless otherwise noted. The competition organizers reserve the right to update the contest timeline if they deem it necessary.

## Code Requirements

### This is a Code Competition

Submissions to this competition must be made through Notebooks. In order for the "Submit to Competition" button to be active after a commit, the following conditions must be met:

- CPU Notebook <= 9 hours run-time
- GPU Notebook <= 4 hours run-time
- No internet access enabled
- External data, freely & publicly available, is allowed, including pre-trained models
- Submission file must be named "submission.csv"

Please see the [Code Competition FAQ](https://www.kaggle.com/docs/competitions#kernels-only-FAQ) for more information on how to submit.

## CVPR 2020

This competition is part of the Fine-Grained Visual Categorization [FGVC7](https://sites.google.com/view/fgvc7/home) workshop at the Computer Vision and Pattern Recognition Conference [CVPR 2020](http://cvpr2020.thecvf.com/). A panel will review the top submissions for the competition based on the description of the methods provided. From this, a subset may be invited to present their results at the workshop. Attending the workshop is not required to participate in the competition, however only teams that are attending the workshop will be considered to present their work.

There is no cash prize for this competition. Attendees presenting in person are responsible for all costs associated with travel, expenses, and fees to attend CVPR 2020. PLEASE NOTE: CVPR frequently sells out early, we cannot guarantee CVPR registration after the competition's end. If you are interested in attending, please plan ahead.

You can see a list of all of the FGVC7 competitions [here](https://sites.google.com/corp/view/fgvc7/competitions).

## Citation

Chenyang Zhang, Christine Kaeser-Chen, Grace Vesom, Jennie Choi, Maggie, Will Cukierski. (2020). iMet Collection 2020 - FGVC7. Kaggle. https://kaggle.com/competitions/imet-2020-fgvc7

# Data

## Dataset Description

In this dataset, you are presented with a large number of artwork images and associated attributes of the art. The dataset has been expanded from the [2019 edition](https://www.kaggle.com/c/imet-2019-fgvc6/) of this competition. Multiple modalities can be expected and the camera sources are unknown. The photographs are often centered for objects, and in the case where the museum artifact is an entire room, the images are scenic in nature.

Each object is annotated by a single annotator without a verification step. Annotators were advised to add multiple labels from an ontology provided by The Met, and additionally are allowed to add free-form text when they see fit. They were able to view the museum's online collection pages and advised to avoid annotating labels already present. The attributes can relate to what one "sees" in the work or what one infers as the object's "utility."

While we have made efforts to make the attribute labels as high quality as possible, you should consider these annotations noisy. There may be a small number of attributes with similar meanings. The competition metric, F2 score, was intentionally chosen to provide some robustness against noisy labels, favoring recall over precision.

This is a synchronous-rerun competition. When you submit, your code will be rerun on a private test set that contains unseen images.

### Files

The filename of each image is its `id`.

- **train.csv** gives the `attribute_ids` for the train images in **/train**
- **/test** contains the test images. You must predict the `attribute_ids` for these images.
- **sample_submission.csv** contains a submission in the correct format
- **labels.csv** provides descriptions of the attributes