import argparse
from pathlib import Path


def main(log_dir: Path) -> float:
    total = 0
    correct = 0
    for result_file in log_dir.glob("**/result.txt"):
        result = result_file.read_text().strip()
        total += 1
        correct += int(result)

    total_cost_dollar = 0
    for cost_file in log_dir.glob("**/cost_dollar.txt"):
        cost_dollar = float(cost_file.read_text().strip())
        total_cost_dollar += cost_dollar

    print("Total Cost in dollar:", total_cost_dollar)
    prec = correct / total
    print("Logging dir:", str(log_dir))
    print("Number of Problems:", total)
    print("Precision:", prec)
    return prec


def get_args() -> argparse.Namespace:
    parser = argparse.ArgumentParser()
    parser.add_argument("--log-dir", required=True, type=Path)

    return parser.parse_args()


if __name__ == "__main__":
    args = get_args()
    main(
        log_dir=args.log_dir,
    )
