#!/bin/bash

TASK_ID=10
EXPERIMENT_NAME="gpt4o20240806-ns1-ne1-t0"
ANSWER_MODEL="gpt-4o-2024-08-06"
JUDGE_MODEL="gpt-4o-2024-08-06"
TEMPERATURE=0.7
JUDGE_TEMPERATURE=0.0
NUM_SIMULATIONS=1
NUM_EXPAND_SAMPLES=1

# NOTE: change the below to your own virtual environment (if you need)
source ./venv/bin/activate

# NOTE: you need to have a .env file in the root directory
if [ -f .env ]; then
  set -a
  source .env
  set +a
else
  echo ".env file not found!"
  exit 1
fi

# Process
echo "SLURM_ARRAY_TASK_ID: $SLURM_ARRAY_TASK_ID"
PYTHONPATH="$PYTHONPATH:." python scripts/run_math_vista.py --experiment_name $EXPERIMENT_NAME --idx $TASK_ID \
  --answer_model $ANSWER_MODEL --temperature $TEMPERATURE --num_simulations $NUM_SIMULATIONS --num_expand_samples $NUM_EXPAND_SAMPLES \
  --judge_model $JUDGE_MODEL --judge_temperature $JUDGE_TEMPERATURE
PYTHONPATH="$PYTHONPATH:." python scripts/evaluate_math_vista.py --experiment_name $EXPERIMENT_NAME --idx $TASK_ID \
  --judge_model $JUDGE_MODEL --judge_temperature $JUDGE_TEMPERATURE
