from typing import Optional

from llm_mcts.tasks.score_arithmetic_game.base_arithmetic_game import (
    ScoreArithmeticGame,
)


class AdditionGame(ScoreArithmeticGame):
    """
    Add the most recent k scores
    """

    def __init__(self, num_rounds: int = 5) -> None:
        self.num_rounds = num_rounds

        def addition(a: Optional[float], b: Optional[float]) -> Optional[float]:
            if a is None or b is None:
                return None
            return a + b

        super().__init__(num_rounds=num_rounds, reducer=addition)
