import argparse
from pathlib import Path
import re

import pydot


logging_dir = (Path(__file__) / ".." / ".." / ".." / "logging" / "swe_bench").resolve()


def parse_args() -> argparse.Namespace:
    parser = argparse.ArgumentParser()
    parser.add_argument("-e", "--experiment_name", type=str, required=True)
    return parser.parse_args()


def main() -> None:
    args = parse_args()
    exp_dir = logging_dir / args.experiment_name
    scores = []
    for digraph_file in exp_dir.glob("mcts_graph_*"):
        if not digraph_file.is_file() or not digraph_file.suffix == "":
            continue
        idx = int(digraph_file.stem.rsplit("_", 1)[1])
        # source = Source.from_file(digraph_file)
        graphs = pydot.graph_from_dot_file(digraph_file)
        assert len(graphs) == 1
        graph = graphs[0]
        assert graph.get_edges()[0] == pydot.Edge("0", "1")
        assert graph.get_nodes()[1].get_name() == "1"
        test_score = re.search(
            r"test score ([0-9\.]+)",
            graph.get_nodes()[1].obj_dict["attributes"]["label"],
        )
        assert test_score is not None
        scores.append((idx, float(test_score.group(1))))

    average_score = sum([score for _, score in scores]) / len(scores)
    print(f"Average score: {average_score} (Total: {len(scores)} cases)")


if __name__ == "__main__":
    main()
