from abc import ABC, abstractmethod
from typing import List

from llm_mcts.mcts_algo.mcts_result import MCTSResult
from llm_mcts.node_ranker.submission import Submission


class Ranker(ABC):
    @abstractmethod
    def top_k_predictions(
        self, mcts_result: MCTSResult, k: int = 3
    ) -> List[Submission]:
        raise NotImplementedError()
