from llm_mcts.prompt_configs import PromptConfig
from llm_mcts.prompts.arc.kou_v1 import KouV1Prompt
from llm_mcts.prompts.arc.yuichi import YuichiPrompt
from llm_mcts.prompts.math_vista.official import MathVistaOfficialPrompt
from llm_mcts.prompts.omni_math.kou_v1 import KouV1Prompt as OmniMathKouV1Prompt
from llm_mcts.prompts.swe_bench.baseline import SWEBenchBaselinePrompt
from llm_mcts.prompts.code_contest.baseline import CodeContestBaselinePrompt
from llm_mcts.prompts.code_contest.cot_v5 import CodeContestCOTV5Prompt
from llm_mcts.prompts.live_code_bench_code_generation.live_code_bench import (
    LiveCodeBenchPrompt as LiveCodeBenchCodeGenerationPrompt,
)
from llm_mcts.prompts.live_code_bench_code_generation.live_code_bench_v10 import (
    LiveCodeBenchPromptV10 as LiveCodeBenchCodeGenerationPromptV10,
)
from llm_mcts.prompts.base import PromptTemplate
from llm_mcts.tasks.arc.task import ARCProblem
from llm_mcts.tasks.math_vista.task import MathVistaTask
from llm_mcts.tasks.omni_math.task import OmniMathTask
from llm_mcts.tasks.swe_bench.task import SWEBenchTask
from llm_mcts.tasks.code_contest.task import CodeContestTask
from llm_mcts.tasks.live_code_bench_code_generation.task import (
    LiveCodeBenchCodeGenerationTask,
)
from llm_mcts.tasks.base import Task


def build_prompt_template(prompt_config: PromptConfig, task: Task) -> PromptTemplate:
    if isinstance(task, ARCProblem):
        if "yuichi" in prompt_config.initial_prompt_type:
            return YuichiPrompt(prompt_config=prompt_config, problem=task)
        elif prompt_config.initial_prompt_type == "kou_v1":
            return KouV1Prompt(prompt_config=prompt_config, problem=task)
        else:
            raise NotImplementedError(
                f"initial_prompt type {prompt_config.initial_prompt_type} not implemented"
            )
    elif isinstance(task, MathVistaTask):
        if prompt_config.initial_prompt_type == "math_vista_official":
            return MathVistaOfficialPrompt(prompt_config=prompt_config, task=task)
        else:
            raise NotImplementedError(
                f"initial_prompt type {prompt_config.initial_prompt_type} not implemented"
            )
    elif isinstance(task, OmniMathTask):
        if prompt_config.initial_prompt_type == "omni_math_kou_v1":
            return OmniMathKouV1Prompt(prompt_config=prompt_config, task=task)
        else:
            raise NotImplementedError(
                f"initial_prompt type {prompt_config.initial_prompt_type} not implemented"
            )
    elif isinstance(task, SWEBenchTask):
        if prompt_config.initial_prompt_type == "swe_bench_baseline":
            return SWEBenchBaselinePrompt(prompt_config=prompt_config, task=task)
        else:
            raise NotImplementedError(
                f"initial_prompt type {prompt_config.initial_prompt_type} not implemented"
            )
    elif isinstance(task, CodeContestTask):
        if prompt_config.initial_prompt_type == "code_contest_baseline":
            return CodeContestBaselinePrompt(prompt_config=prompt_config, task=task)
        elif prompt_config.initial_prompt_type == "code_contest_cot_v5":
            return CodeContestCOTV5Prompt(prompt_config=prompt_config, task=task)
        else:
            raise NotImplementedError(
                f"initial_prompt type {prompt_config.initial_prompt_type} not implemented"
            )
    elif isinstance(task, LiveCodeBenchCodeGenerationTask):
        if prompt_config.initial_prompt_type == "live_code_bench_code_generation":
            return LiveCodeBenchCodeGenerationPrompt(
                prompt_config=prompt_config, task=task
            )
        elif prompt_config.initial_prompt_type == "live_code_bench_code_generation_v10":
            return LiveCodeBenchCodeGenerationPromptV10(
                prompt_config=prompt_config, task=task
            )
        else:
            raise NotImplementedError(
                f"initial_prompt type {prompt_config.initial_prompt_type} not implemented"
            )
    else:
        raise NotImplementedError(
            f"build_prompt_template for task {task} not implemented"
        )
