import argparse
from pathlib import Path

from llm_mcts.mcts_algo.mcts_result import MCTSResult
from llm_mcts.mcts_scorer.default import DefaultScorer
from llm_mcts.tasks.live_code_bench_code_generation.task import (
    LiveCodeBenchCodeGenerationTask,
)
from llm_mcts.visualize_mcts import render_mcts_graph

logging_dir = (
    Path(__file__) / ".." / ".." / ".." / "logging" / "live_code_bench_code_generation"
).resolve()


def parse_args() -> argparse.Namespace:
    parser = argparse.ArgumentParser()
    parser.add_argument("-e", "--experiment_name", type=str, required=True)
    parser.add_argument("-i", "--idx", type=int, required=True)
    parser.add_argument("--release_version", type=str, default="release_v4")
    return parser.parse_args()


def main() -> None:
    args = parse_args()

    save_dir = logging_dir / args.experiment_name
    assert save_dir.is_dir(), f"Experiment {args.experiment_name} does not exist"

    mcts_result = MCTSResult.load(save_dir / f"mcts_result_{args.idx}.pkl")
    scorer = DefaultScorer()
    task = LiveCodeBenchCodeGenerationTask.load_record(
        idx=args.idx,
        release_version=args.release_version,
    )
    render_mcts_graph(
        mcts_result, scorer, task, save_dir / f"mcts_graph_{args.idx}", view=False
    )


if __name__ == "__main__":
    main()
