import argparse
import json
from pathlib import Path
from tqdm import tqdm


logging_dir = (Path(__file__) / ".." / ".." / ".." / "logging" / "math_vista").resolve()


def parse_args() -> argparse.Namespace:
    parser = argparse.ArgumentParser()
    parser.add_argument("-e", "--experiment_name", type=str, required=True)
    return parser.parse_args()


def main() -> None:
    args = parse_args()

    save_dir = logging_dir / args.experiment_name
    assert save_dir.is_dir(), f"Experiment {args.experiment_name} does not exist"

    each_result_json_paths = sorted(list((save_dir / "each_result").glob("*.json")))
    prediction_jsonl_path = save_dir / "prediction.jsonl"

    # gather each result json into one jsonl file
    with open(prediction_jsonl_path, "w") as f:
        for each_result_json_path in tqdm(each_result_json_paths):
            with open(each_result_json_path, "r") as each_result_json_f:
                each_result = json.load(each_result_json_f)
                f.write(json.dumps(each_result) + "\n")

    print(f"Saved to {prediction_jsonl_path}")


if __name__ == "__main__":
    main()
