from data_provider.data_loader_imputation import Dataset_ETT_hour, Dataset_ETT_minute, Dataset_Custom, Dataset_M4, PSMSegLoader, \
    MSLSegLoader, SMAPSegLoader, SMDSegLoader, SWATSegLoader,Dataset_PEMS
from data_provider.uea import collate_fn
from torch.utils.data import DataLoader
from data_provider.data_fusion import load_dataset_dataloader
from data_provider.data_loader_forecasting import Dataset_ETT_hour as Forecasting_Dataset_ETT_hour
from data_provider.data_loader_forecasting import Dataset_ETT_minute as Forecasting_Dataset_ETT_minute
from data_provider.data_loader_forecasting import Dataset_Custom as Forecasting_Dataset_Custom
data_dict = {
    'ETTh1': Dataset_ETT_hour,
    'ETTh2': Dataset_ETT_hour,
    'ETTm1': Dataset_ETT_minute,
    'ETTm2': Dataset_ETT_minute,
    'custom': Dataset_Custom,
    'pems':Dataset_PEMS,
    'm4': Dataset_M4,
    'PSM': PSMSegLoader,
    'MSL': MSLSegLoader,
    'SMAP': SMAPSegLoader,
    'SMD': SMDSegLoader,
    'SWAT': SWATSegLoader,
    'ETTh1_forecasting':Forecasting_Dataset_ETT_hour,
    'ETTh2_forecasting': Forecasting_Dataset_ETT_hour,
    'ETTm1_forecasting': Forecasting_Dataset_ETT_minute,
    'ETTm2_forecasting': Forecasting_Dataset_ETT_minute,
    'custom_forecasting':Forecasting_Dataset_Custom
}


def data_provider(args, flag):
    Data = data_dict[args.data]
    timeenc = 0 if args.embed != 'timeF' else 1

    if flag == 'test':
        shuffle_flag = False
        drop_last = True
        if args.task_name == 'anomaly_detection' or args.task_name == 'classification':
            batch_size = args.batch_size
        else:
            batch_size = args.batch_size  # bsz=1 for evaluation
        freq = args.freq
    else:
        shuffle_flag = True # must set to False when fewshot
        drop_last = True
        batch_size = args.batch_size  # bsz for train and valid
        freq = args.freq

    if args.task_name == 'anomaly_detection':
        drop_last = False
        data_set = Data(
            root_path=args.root_path,
            win_size=args.seq_len,
            flag=flag,
        )
        print(flag, len(data_set))
        data_loader = DataLoader(
            data_set,
            batch_size=batch_size,
            shuffle=shuffle_flag,
            num_workers=args.num_workers,
            drop_last=drop_last)
        return data_set, data_loader
    elif args.task_name == 'classification':
        drop_last = False
        data_set = Data(
            root_path=args.root_path,
            flag=flag,
        )

        data_loader = DataLoader(
            data_set,
            batch_size=batch_size,
            shuffle=shuffle_flag,
            num_workers=args.num_workers,
            drop_last=drop_last,
            collate_fn=lambda x: collate_fn(x, max_len=args.seq_len)
        )
        return data_set, data_loader

    elif args.task_name == 'allinone':
        if flag=='val':
            batch_size = batch_size*4
        data_set,data_loader = load_dataset_dataloader(input_length=args.seq_len,horizon=args.pred_len,batch_size=batch_size,num_workers=8,channel_group=1,flag=flag,origin_missrate=args.origin_missrate)
        return data_set, data_loader
    else:
        if args.data == 'm4':
            drop_last = False
        data_set = Data(
            root_path=args.root_path,
            data_path=args.data_path,
            flag=flag,
            size=[args.seq_len, args.label_len, args.pred_len],
            features=args.features,
            target=args.target,
            timeenc=timeenc,
            freq=freq
        )
        print(flag, len(data_set))
        data_loader = DataLoader(
            data_set,
            batch_size=batch_size,
            shuffle=shuffle_flag,
            num_workers=args.num_workers,
            drop_last=drop_last)
        return data_set, data_loader
