# 项目文档中心

## 核心规范文档

### 已完成文档
1. **[代码规范指南](../CODING_STANDARDS.md)** - 代码风格、命名约定、项目结构等编码标准
2. **[实验指南](../EXPERIMENT_GUIDE.md)** - 实验设计、执行、评估的标准流程
3. **[配置管理指南](../CONFIG_GUIDE.md)** - 配置文件结构、参数管理、环境变量使用
4. **[项目架构文档](../ARCHITECTURE.md)** - 系统设计、模块职责、数据流

### 待完成文档（按优先级）
5. **数据管理指南** (`DATA_GUIDE.md`) - 数据集管理、预处理标准、缓存策略
6. **模型开发指南** (`MODEL_GUIDE.md`) - 模型实现标准、训练流程、评估协议
7. **环境配置说明** (`SETUP.md`) - 环境搭建、依赖安装、常见问题

## 文档使用说明

### 对于新加入项目的研究者
1. 首先阅读 **代码规范指南** 了解项目的编码标准
2. 然后阅读 **实验指南** 了解如何设计和执行实验
3. 根据具体任务查阅相关专项文档

### 对于日常开发
- 编写代码时参考 **代码规范指南**
- 设计实验时参考 **实验指南**
- 遇到特定问题时查阅对应的专项文档

### 文档维护原则
- 文档应与代码同步更新
- 发现文档与实际不符时应及时修正
- 新增重要功能时应更新相关文档
- 定期审查和更新文档内容

## 快速参考

### 关键原则
- **无静默失败**：错误必须明确报告
- **数据真实性**：禁止使用mock数据（除初期测试）
- **可重现性**：固定种子、版本、环境
- **配置集中**：单一配置源，避免分散

### 命名约定速查
- 类名：`PascalCase`
- 函数：`snake_case`
- 常量：`UPPER_SNAKE_CASE`
- 文件：`module_name.py`

### 实验流程速查
1. 验证配置
2. 设置环境
3. 准备数据
4. 训练模型
5. 评估结果
6. 生成报告

---

*文档中心持续更新中*
*最后更新：2025.8.8*
