# 效率对比实验 (exp1_speed)

本目录包含三个子实验，用于评估不同序列化方法在各方面的效率对比。

## 目录结构

```
exp1_speed/
├── token_length/              # 序列化长度对比
│   ├── plot_token_length.py   # 画图脚本
│   └── qm9hook_token_length.csv  # 示例数据（QM9Hook数据集）
├── serialize_time/            # 序列化速度对比  
│   ├── plot_serialize_speed.py   # 画图脚本
│   └── qm9hook_serialize_speed.csv  # 示例数据
├── train_time/               # 训练效率对比
│   ├── plot_train_efficiency.py  # 画图脚本
│   └── qm9hook_train_efficiency.csv  # 示例数据
└── README.md                 # 本文件
```

## 实验说明

### 1. 序列化长度对比 (token_length/)

**目的**: 比较不同序列化方法的序列长度及BPE压缩效果

**图表内容**:
- 横轴：序列化方法（dfs, bfs, topo, smiles, eulerian, feuler, cpp）
- 纵轴：序列长度（左）和压缩比（右，范围2~15）
- 三组柱子：原始序列长度、BPE压缩后长度、压缩比（1/压缩率）

**CSV格式**:
```csv
serialization_method,original_length,bpe_compressed_length,compression_rate
dfs,145.2,15.3,0.105
```

**运行方式**:
```bash
cd token_length/
python plot_token_length.py
```

### 2. 序列化速度对比 (serialize_time/)

**目的**: 比较不同序列化方法的处理速度

**图表内容**:
- 横轴：序列化方法
- 纵轴：每秒序列化的图数量 (graphs/second)
- 每个方法一个柱子

**CSV格式**:
```csv
serialization_method,graphs_per_second
dfs,1250.3
```

**运行方式**:
```bash
cd serialize_time/
python plot_serialize_speed.py
```

### 3. 训练效率对比 (train_time/)

**目的**: 比较序列化方法与传统图神经网络的训练效率

**图表内容**:
- 横轴：方法名称（包括序列化方法的有/无BPE两种情况 + GCN/GraphGPS/Graph Mamba）
- 纵轴：每个epoch的平均训练时间（秒）
- 按方法类型着色显示

**CSV格式**:
```csv
method_name,epoch_time_seconds,method_type,method_group
dfs,45.2,serialization_no_bpe,dfs
dfs_bpe,38.7,serialization_with_bpe,dfs
GCN,89.4,graph_neural_network,gnn
```

**运行方式**:
```bash
cd train_time/
python plot_train_efficiency.py
```

## 实验配置

### 固定配置参数
- **数据集**: QM9Hook（其他数据集结果见appendix）
- **BPE配置**: 
  - 最大合并轮数: 2000
  - 最低出现频率: 100（qm9数据集）/ 10（qm9test数据集）
- **多重采样**: 每个图进行多次采样测试
- **测试模型**: GTE-100M参数BERT模型
- **测试设备**: RTX 4090
- **其他**: 测试时忽略padding位置

### 预期结论

1. **序列长度**: 
   - 不可恢复图结构的方法（搜索、拓扑排序）序列更短
   - 可恢复图结构的方法（SMILES、Eulerian、Graph_Seq）原始序列较长，但BPE压缩后能达到接近甚至更短的效果
   - BPE压缩率约为10%（即压缩到原序列长度的10%）

2. **序列化速度**:
   - 符合复杂度分析：搜索和拓扑排序最快
   - SMILES与Eulerian速度相仿
   - CPP方法相对较慢
   - 对大图推荐使用Eulerian方法

3. **训练效率**:
   - 使用BPE压缩的序列化方法训练时间显著低于传统图神经网络
   - 即使使用100M参数的GTE BERT模型，仍有约2倍加速比

## 添加新数据集

要添加新数据集的实验结果，只需在相应文件夹下添加新的CSV文件：
- `[dataset_name]_token_length.csv`
- `[dataset_name]_serialize_speed.csv` 
- `[dataset_name]_train_efficiency.csv`

脚本会自动检测并处理所有CSV文件。

## 图表样式

所有图表使用统一的matplotlib样式设置（来自`../plot_utils.py`）：
- 字体: Arial, 粗体  
- 分辨率: 300 DPI
- 格式: JPG
- 标注语言: 英文
- 横轴标签: 不旋转
- 序列化方法名称: 基于src/algorithms/serializer/serializer_factory.py定义
- 压缩比: 范围2~15（1/压缩率）
- 训练效率图: w/w/o BPE柱子分组显示
- 颜色方案: 统一的调色板
- 输出目录: 各自文件夹下直接保存
