# Heterogeneous Loss Function with Aggressive Rejection for Contaminated data in anomaly detection
This repository provides a PyTorch implementation of Heterogeneous loss function with aggressive rejection.

# Abstract
A clean dataset for training is crucial for detecting anomalous data. However, a clean dataset is challenging to produce in practice. Here, heterogeneous loss function with aggressive rejection is proposed, which strengthens robustness against contamination. Aggressive rejection constrains training on the intersection of normal and abnormal distributions to handle the potential anomalies. Heterogeneous loss function utilizes adaptive mini-batch stochastic choice of an order of asymptotic polynomial of GA loss, which dynamically optimizes the gradient for the intersection further. Through the proposed method, mean square error based models can outperform various robust loss functions and demonstrate comparable performance with robust models for contaminated data on three image datasets.

# Run Example
```python
python main.py --config="./json/AE.json"
```

"AE.json" can be replaced by other models such as MemAE and DSVDD etc.

# Code Reference

1. Deep One-Class Classification (DSVDD): <https://github.com/lukasruff/Deep-SVDD-PyTorch>  
1. Memory-augmented Deep Autoencoder (MemAE): <https://github.com/donggong1/memae-anomaly-detection>  
1. RVAE-ABFA: <https://github.com/RVAEBFA/RVAEBFA>  
1. Normality-Calibrated Autoencoder (NCAE): <https://github.com/andreYoo/NCAE_UAD>  



