import os
import logging
import shutil


def log(string):
	"""
		Print string in console and write string in log file(logger and backup logger).
	"""
	logger = logging.getLogger("logger")
	logger.info(string)
	
def make_logger(model_name,backup_path):
	"""
		Make logger and backup logger. Logger is INFO-level logger and backup logger is DEBUG-level logger. Logge is saved in "./ckpt/info.log" and backup logger is saved in "./log/Y-M-D-H-M/info.log" format.
	"""
	#Make logger
	path=f"./ckpt/{model_name}/"
	if not os.path.isdir(path):
		os.mkdir(path)

	logger = logging.getLogger("logger")
	if len(logger.handlers) > 0:
		logger.handlers.clear()
		logger = logging.getLogger()
		logger.handlers.clear()
		logger = logging.getLogger("logger")
		
	log_file = [s for s in os.listdir("./log") if os.path.isdir(os.path.join("./log", s))]
	log_max = 10
	if len(log_file) > log_max:
		log_file.sort(key=lambda s: os.path.getmtime(os.path.join("./log",s)), reverse=True)
		for i, file_name in enumerate(log_file):
			if i >= log_max:
				shutil.rmtree(f"./log/{file_name}")
	logging.basicConfig(filename=path+"info.log",level=logging.INFO, filemode='w')
	logger.setLevel(logging.INFO)

	formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
	file_handler = logging.FileHandler(backup_path+"info.log")
	file_handler.setLevel(logging.INFO)
	file_handler.setFormatter(formatter)
	logger.addHandler(file_handler)

#	stream_handler= logging.StreamHandler()
#	stream_handler.setLevel(logging.INFO)
#	stream_handler.setFormatter(formatter)
#	logger.addHandler(stream_handler)


