# On Causal Discovery in thePresence of Deterministic Relations

This is the implementation of synthetic experiments for the paper "On Causal Discovery in thePresence of Deterministic Relations".

## Overview

- In this paper, we develop a novel framework for causal discovery that can detect and handle deterministic relations, called Determinism-aware Greedy Equivalent Search (DGES). 

- DGES comprises three phases: (1) run Greedy Equivalent Search (GES) to obtain an initial graph, (2) identify deterministic clusters (i.e., variables with deterministic relationships), and (3) perform exact search exclusively on each deterministic cluster and its neighbors. 

- The proposed DGES accommodates both linear and nonlinear causal relationships, as well as both continuous and discrete data types. 


# How to Run

- Installation: 

```sh
# Set up a new conda environment with Python 3.8.
conda create -n DGES python=3.8
conda activate DGES

# Install necessary causal-learn.
pip install causal-learn

# Install other python libraries.
pip install numpy pydot networkx 
```

- Quick start:
```sh
# Parameters:
#     method: which method to run
#     count:  number of instances to evaluate
#     d: number of variables
#     n: number of samples 
python run_dges_linear_1DC.py
python run_dges_linear_2DC.py
python run_dges_nonlinear_1DC.py
python run_dges_nonlinear_2DC.py
```

## Acknowledgements


We would like to sincerely thank these related works and open-sourced codes which our work is based on:

- Causal-learn package: [https://github.com/py-why/causal-learn](https://github.com/py-why/causal-learn).
- GES implementation: [https://github.com/juangamella/ges](https://github.com/juangamella/ges).