#!/bin/sh

cd `dirname $0`
cd src

DATA="citibike"
START_DATE=201703
END_DATE=202103
FREQ="H"
PERIOD=168  # weekly pattern in hourly data
T_STEP=500
F_STEP=500
MAX_REGIME=100
N_TRIAL=1
K=15
A=0.4

python3 main.py $DATA "assmf" $PERIOD \
        --n_components $K \
        --n_regimes $MAX_REGIME \
        --learning_rate $A \
        --init_cycle 3 \
        --train_span $F_STEP \
        --update_freq $PERIOD \
        --forecast_step $F_STEP \
        --n_trial $N_TRIAL \
        --citibike_key userage \
        --start_step 1000 \
        --as_tensor
