import argparse
import os
import sys
import yaml

# Ensure local src/ is importable when running from repo root
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), "..", "src")))

from m4olgen.training import train_grpo  # noqa: E402


def main():
    parser = argparse.ArgumentParser(description="GRPO training with LoRA")
    parser.add_argument("--config", default="config.yaml", help="Path to YAML config (default: config.yaml)")
    args = parser.parse_args()

    with open(args.config, "r", encoding="utf-8") as f:
        cfg = yaml.safe_load(f)

    # Ensure experiment directory exists
    exp_dir = cfg.get("project", {}).get("exp_dir", "experiments")
    os.makedirs(exp_dir, exist_ok=True)

    train_grpo(cfg)


if __name__ == "__main__":
    main()
