# BossFight Training

## Installation

```console
conda create -n bossfight python=3.7 --yes

conda activate bossfight

conda install pytorch torchvision torchaudio cudatoolkit=11.3 -c pytorch

pip install mlagents-envs==0.28.0

pip install -r requirements.txt

# (windows only)
pip install windows-curses==2.2.0

cd bossfight

pip install -e .

pip install gym==0.15.3
```

## Training

```
python -m neroRL.train --config=./recurrence_perturbation.yaml
```

The training produces log files, tensorboard summaries and checkpoints.

## Evaluation
Specifcy the path to the model in `recurrence_perturbation.yaml`.
```
python -m neroRL.eval --config=./recurrence_perturbation.yaml
```

## Evaluate checkpoints
```
python -m neroRL.eval_checkpoints --config=./recurrence_perturbation.yaml --path=./checkpoints/*run_id*/*directory of checkpoints*/ --name=novel_0.res
```
The results file can be loaded with pickle. The restored object is a dictionary containing all results.