# GRU-PPO Training

## Installation

```console
conda create -n gru-ppo python=3.7 --yes

conda activate gru-ppo

conda install pytorch torchvision torchaudio cudatoolkit=11.3 -c pytorch

pip install mlagents-envs==0.28.0

pip install -r requirements.txt

# (windows only)
pip install windows-curses==2.2.0

cd gru_ppo

pip install -e .

pip install gym==0.24.1
```

## Training

```
python -m neroRL.train --config=./mmbg/gru_ppo.yaml
```

The training produces log files, tensorboard summaries and checkpoints.

## Evaluation
Specifcy the path to the model in `gru_ppo.yaml`.
```
python -m neroRL.eval --config=./mmbg/gru_ppo.yaml
```

## Evaluate checkpoints
```
python -m neroRL.eval_checkpoints --config=./mmbg/gru_ppo.yaml --path=./checkpoints/*run_id*/*directory of checkpoints*/ --name=novel_0.res
```
The results file can be loaded with pickle. The restored object is a dictionary containing all results.