# HELM Training

## Installation

```console
conda create -n helm python=3.7 --yes

conda activate helm

conda install pytorch torchvision torchaudio cudatoolkit=11.3 -c pytorch

pip install mlagents-envs==0.28.0

pip install -r requirements.txt


# (windows only)
pip install windows-curses==2.2.0

cd gru_ppo

pip install -e .

pip install gym==0.24.1
```

## Training

```
python -m neroRL.train --config=./mm_act_grid.yaml
```

The training produces log files, tensorboard summaries and checkpoints.

## Evaluation
Specifcy the path to the model in `mm_act_grid.yaml`.
```
python -m neroRL.eval --config=./mm_act_grid.yaml
```

## Evaluate checkpoints
```
python -m neroRL.eval_checkpoints --config=./mm_act_grid.yaml --path=./checkpoints/*run_id*/*directory of checkpoints*/ --name=novel_0.res
```
The results file can be loaded with pickle. The restored object is a dictionary containing all results.