## Conda environment:

- Reproduce the conda environment using:

```shell
conda env create --name markovian_fl --file=environment.yml
conda activate markovian_fl
```

## Time-series Dataset:

- Download and unzip the dataset:

```shell
wget https://archive.ics.uci.edu/static/public/501/beijing+multi+site+air+quality+data.zip
unzip beijing+multi+site+air+quality+data.zip -d data
rm -f beijing+multi+site+air+quality+data.zip
cd data
rm -f 2A2478DC-8517-4490-9FA7-36F9A7A542BE.JPG data.csv test.csv
unzip PRSA2017_Data_20130301-20170228.zip -d raw
```

- Preprocessing:

```shell
cd "time series"
python preprocessing.py
python plot_helper.py
```

- Run the main experiments and plot the figures:

```shell
cd "time series"
python main.py
python plot.py
```

- The figures are saved in ``figures``.

## Synthetic dataset

- Run the additional experiments and plot the figures:

```shell
cd synthetic
python main.py
python plot_paper.py
```

- The figures are saved in ``figures``.