This project is the code implementation of the paper ***IoT-LLM: Enhancing Real-World IoT Task Reasoning with Large Language Models**, the structure of the project is shown as follows:

```
IoT-Agent/
├── data/
│   ├── ECG
│   ├── IMU
│   └── machine_detect
├── common/
│   ├── args.py
│   ├── generate_prompt.py
│   ├── model.py
│   ├── read_data.py
│   └── utils.py
├── knowledge/
│   ├── ecg_detection/
│   |   ├── demo-knowledge/
│   |   └── domain-knowledge/
│   ├── imu_HAR/
│   |   ├── demo-knowledge/
│   |   └── domain-knowledge/
│   └── machine_detection/
│       ├── demo-knowledge/
│       └── domain-knowledge/
├── models/
|   ├── LLaMa2-7b-32k/
|   └── Mistral-7b-instruct-v0.3/
├── results/
├── imports.py
├── requirements.txt
├── openAI_API_key.py
├── main.py
├── run.sh
└── README.md
```

To run the project, you should first build up the evironment as shown in requirements.txt:

```
pip install -r requirement.txt
```

Then,  run the run.sh to abtain experiement results of the paper:

```
bash run.sh 
```
