LANG_DATASETS = (
    "asu_table_top_converted_externally_to_rlds",
    "bc_z",
    "berkeley_fanuc_manipulation",
    "berkeley_mvp_converted_externally_to_rlds",
    "berkeley_rpt_converted_externally_to_rlds",
    "bridge",
    "cmu_franka_exploration_dataset_converted_externally_to_rlds",
    "cmu_play_fusion",
    "cmu_stretch",
    "dlr_edan_shared_control_converted_externally_to_rlds",
    "eth_agent_affordances",
    "fractal20220817_data",
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds",
    "imperialcollege_sawyer_wrist_cam",
    "jaco_play",
    "kaist_nonprehensile_converted_externally_to_rlds",
    "language_table",
    "maniskill_dataset_converted_externally_to_rlds",
    "nyu_rot_dataset_converted_externally_to_rlds",
    "roboturk",
    "stanford_hydra_dataset_converted_externally_to_rlds",
    "stanford_robocook_converted_externally_to_rlds",
    "taco_play",
    "tokyo_u_lsmo_converted_externally_to_rlds",
    "ucsd_kitchen_dataset_converted_externally_to_rlds",
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds",
    "utaustin_mutex",
    "utokyo_saytap_converted_externally_to_rlds",
    "viola",
)


def dataset2version(dataset_name):
    if dataset_name == "robo_net":
        version = "1.0.0"
    elif dataset_name == "language_table":
        version = "0.0.1"
    else:
        version = "0.1.0"
    return version


DATA_FILE_LENGTHS = {
    "asu_table_top_converted_externally_to_rlds_0.1.0/0.1.0/asu_table_top_converted_externally_to_rlds-train.tfrecord-00000-of-00008": 11,
    "asu_table_top_converted_externally_to_rlds_0.1.0/0.1.0/asu_table_top_converted_externally_to_rlds-train.tfrecord-00001-of-00008": 11,
    "asu_table_top_converted_externally_to_rlds_0.1.0/0.1.0/asu_table_top_converted_externally_to_rlds-train.tfrecord-00002-of-00008": 14,
    "asu_table_top_converted_externally_to_rlds_0.1.0/0.1.0/asu_table_top_converted_externally_to_rlds-train.tfrecord-00003-of-00008": 13,
    "asu_table_top_converted_externally_to_rlds_0.1.0/0.1.0/asu_table_top_converted_externally_to_rlds-train.tfrecord-00004-of-00008": 18,
    "asu_table_top_converted_externally_to_rlds_0.1.0/0.1.0/asu_table_top_converted_externally_to_rlds-train.tfrecord-00005-of-00008": 17,
    "asu_table_top_converted_externally_to_rlds_0.1.0/0.1.0/asu_table_top_converted_externally_to_rlds-train.tfrecord-00006-of-00008": 14,
    "asu_table_top_converted_externally_to_rlds_0.1.0/0.1.0/asu_table_top_converted_externally_to_rlds-train.tfrecord-00007-of-00008": 12,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00000-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00001-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00002-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00003-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00004-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00005-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00006-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00007-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00008-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00009-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00010-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00011-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00012-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00013-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00014-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00015-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00016-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00017-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00018-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00019-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00020-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00021-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00022-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00023-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00024-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00025-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00026-of-01024": 59,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00027-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00028-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00029-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00030-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00031-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00032-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00033-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00034-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00035-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00036-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00037-of-01024": 52,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00038-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00039-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00040-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00041-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00042-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00043-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00044-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00045-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00046-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00047-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00048-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00049-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00050-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00051-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00052-of-01024": 48,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00053-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00054-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00055-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00056-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00057-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00058-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00059-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00060-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00061-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00062-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00063-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00064-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00065-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00066-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00067-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00068-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00069-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00070-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00071-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00072-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00073-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00074-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00075-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00076-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00077-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00078-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00079-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00080-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00081-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00082-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00083-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00084-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00085-of-01024": 58,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00086-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00087-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00088-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00089-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00090-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00091-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00092-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00093-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00094-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00095-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00096-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00097-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00098-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00099-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00100-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00101-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00102-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00103-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00104-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00105-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00106-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00107-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00108-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00109-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00110-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00111-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00112-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00113-of-01024": 53,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00114-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00115-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00116-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00117-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00118-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00119-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00120-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00121-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00122-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00123-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00124-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00125-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00126-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00127-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00128-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00129-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00130-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00131-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00132-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00133-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00134-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00135-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00136-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00137-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00138-of-01024": 51,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00139-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00140-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00141-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00142-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00143-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00144-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00145-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00146-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00147-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00148-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00149-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00150-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00151-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00152-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00153-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00154-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00155-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00156-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00157-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00158-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00159-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00160-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00161-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00162-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00163-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00164-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00165-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00166-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00167-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00168-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00169-of-01024": 51,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00170-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00171-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00172-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00173-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00174-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00175-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00176-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00177-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00178-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00179-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00180-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00181-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00182-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00183-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00184-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00185-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00186-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00187-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00188-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00189-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00190-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00191-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00192-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00193-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00194-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00195-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00196-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00197-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00198-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00199-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00200-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00201-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00202-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00203-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00204-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00205-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00206-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00207-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00208-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00209-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00210-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00211-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00212-of-01024": 54,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00213-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00214-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00215-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00216-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00217-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00218-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00219-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00220-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00221-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00222-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00223-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00224-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00225-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00226-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00227-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00228-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00229-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00230-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00231-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00232-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00233-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00234-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00235-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00236-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00237-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00238-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00239-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00240-of-01024": 57,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00241-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00242-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00243-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00244-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00245-of-01024": 21,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00246-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00247-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00248-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00249-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00250-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00251-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00252-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00253-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00254-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00255-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00256-of-01024": 21,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00257-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00258-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00259-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00260-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00261-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00262-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00263-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00264-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00265-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00266-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00267-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00268-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00269-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00270-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00271-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00272-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00273-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00274-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00275-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00276-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00277-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00278-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00279-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00280-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00281-of-01024": 56,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00282-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00283-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00284-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00285-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00286-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00287-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00288-of-01024": 24,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00289-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00290-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00291-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00292-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00293-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00294-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00295-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00296-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00297-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00298-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00299-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00300-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00301-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00302-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00303-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00304-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00305-of-01024": 53,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00306-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00307-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00308-of-01024": 56,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00309-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00310-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00311-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00312-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00313-of-01024": 25,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00314-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00315-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00316-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00317-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00318-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00319-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00320-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00321-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00322-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00323-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00324-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00325-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00326-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00327-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00328-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00329-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00330-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00331-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00332-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00333-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00334-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00335-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00336-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00337-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00338-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00339-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00340-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00341-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00342-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00343-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00344-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00345-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00346-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00347-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00348-of-01024": 51,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00349-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00350-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00351-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00352-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00353-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00354-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00355-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00356-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00357-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00358-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00359-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00360-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00361-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00362-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00363-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00364-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00365-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00366-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00367-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00368-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00369-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00370-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00371-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00372-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00373-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00374-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00375-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00376-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00377-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00378-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00379-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00380-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00381-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00382-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00383-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00384-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00385-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00386-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00387-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00388-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00389-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00390-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00391-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00392-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00393-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00394-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00395-of-01024": 48,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00396-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00397-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00398-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00399-of-01024": 48,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00400-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00401-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00402-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00403-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00404-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00405-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00406-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00407-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00408-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00409-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00410-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00411-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00412-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00413-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00414-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00415-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00416-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00417-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00418-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00419-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00420-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00421-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00422-of-01024": 52,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00423-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00424-of-01024": 52,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00425-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00426-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00427-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00428-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00429-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00430-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00431-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00432-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00433-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00434-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00435-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00436-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00437-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00438-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00439-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00440-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00441-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00442-of-01024": 51,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00443-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00444-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00445-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00446-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00447-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00448-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00449-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00450-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00451-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00452-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00453-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00454-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00455-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00456-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00457-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00458-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00459-of-01024": 21,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00460-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00461-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00462-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00463-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00464-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00465-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00466-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00467-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00468-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00469-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00470-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00471-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00472-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00473-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00474-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00475-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00476-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00477-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00478-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00479-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00480-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00481-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00482-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00483-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00484-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00485-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00486-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00487-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00488-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00489-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00490-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00491-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00492-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00493-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00494-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00495-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00496-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00497-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00498-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00499-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00500-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00501-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00502-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00503-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00504-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00505-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00506-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00507-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00508-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00509-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00510-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00511-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00512-of-01024": 61,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00513-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00514-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00515-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00516-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00517-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00518-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00519-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00520-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00521-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00522-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00523-of-01024": 54,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00524-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00525-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00526-of-01024": 53,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00527-of-01024": 54,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00528-of-01024": 61,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00529-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00530-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00531-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00532-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00533-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00534-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00535-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00536-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00537-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00538-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00539-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00540-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00541-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00542-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00543-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00544-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00545-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00546-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00547-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00548-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00549-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00550-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00551-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00552-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00553-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00554-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00555-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00556-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00557-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00558-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00559-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00560-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00561-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00562-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00563-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00564-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00565-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00566-of-01024": 26,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00567-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00568-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00569-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00570-of-01024": 51,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00571-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00572-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00573-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00574-of-01024": 48,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00575-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00576-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00577-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00578-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00579-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00580-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00581-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00582-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00583-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00584-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00585-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00586-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00587-of-01024": 55,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00588-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00589-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00590-of-01024": 51,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00591-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00592-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00593-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00594-of-01024": 26,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00595-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00596-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00597-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00598-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00599-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00600-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00601-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00602-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00603-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00604-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00605-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00606-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00607-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00608-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00609-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00610-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00611-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00612-of-01024": 25,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00613-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00614-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00615-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00616-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00617-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00618-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00619-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00620-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00621-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00622-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00623-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00624-of-01024": 54,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00625-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00626-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00627-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00628-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00629-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00630-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00631-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00632-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00633-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00634-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00635-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00636-of-01024": 25,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00637-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00638-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00639-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00640-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00641-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00642-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00643-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00644-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00645-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00646-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00647-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00648-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00649-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00650-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00651-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00652-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00653-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00654-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00655-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00656-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00657-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00658-of-01024": 25,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00659-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00660-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00661-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00662-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00663-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00664-of-01024": 25,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00665-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00666-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00667-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00668-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00669-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00670-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00671-of-01024": 48,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00672-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00673-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00674-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00675-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00676-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00677-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00678-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00679-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00680-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00681-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00682-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00683-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00684-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00685-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00686-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00687-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00688-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00689-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00690-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00691-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00692-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00693-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00694-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00695-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00696-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00697-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00698-of-01024": 53,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00699-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00700-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00701-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00702-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00703-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00704-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00705-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00706-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00707-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00708-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00709-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00710-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00711-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00712-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00713-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00714-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00715-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00716-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00717-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00718-of-01024": 52,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00719-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00720-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00721-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00722-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00723-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00724-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00725-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00726-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00727-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00728-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00729-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00730-of-01024": 51,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00731-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00732-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00733-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00734-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00735-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00736-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00737-of-01024": 28,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00738-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00739-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00740-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00741-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00742-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00743-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00744-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00745-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00746-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00747-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00748-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00749-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00750-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00751-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00752-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00753-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00754-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00755-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00756-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00757-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00758-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00759-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00760-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00761-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00762-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00763-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00764-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00765-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00766-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00767-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00768-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00769-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00770-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00771-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00772-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00773-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00774-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00775-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00776-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00777-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00778-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00779-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00780-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00781-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00782-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00783-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00784-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00785-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00786-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00787-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00788-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00789-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00790-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00791-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00792-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00793-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00794-of-01024": 26,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00795-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00796-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00797-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00798-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00799-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00800-of-01024": 56,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00801-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00802-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00803-of-01024": 48,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00804-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00805-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00806-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00807-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00808-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00809-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00810-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00811-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00812-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00813-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00814-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00815-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00816-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00817-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00818-of-01024": 54,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00819-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00820-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00821-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00822-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00823-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00824-of-01024": 23,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00825-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00826-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00827-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00828-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00829-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00830-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00831-of-01024": 21,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00832-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00833-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00834-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00835-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00836-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00837-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00838-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00839-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00840-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00841-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00842-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00843-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00844-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00845-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00846-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00847-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00848-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00849-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00850-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00851-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00852-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00853-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00854-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00855-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00856-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00857-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00858-of-01024": 25,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00859-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00860-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00861-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00862-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00863-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00864-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00865-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00866-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00867-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00868-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00869-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00870-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00871-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00872-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00873-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00874-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00875-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00876-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00877-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00878-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00879-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00880-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00881-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00882-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00883-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00884-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00885-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00886-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00887-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00888-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00889-of-01024": 49,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00890-of-01024": 24,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00891-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00892-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00893-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00894-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00895-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00896-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00897-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00898-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00899-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00900-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00901-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00902-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00903-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00904-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00905-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00906-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00907-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00908-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00909-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00910-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00911-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00912-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00913-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00914-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00915-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00916-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00917-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00918-of-01024": 51,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00919-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00920-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00921-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00922-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00923-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00924-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00925-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00926-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00927-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00928-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00929-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00930-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00931-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00932-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00933-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00934-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00935-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00936-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00937-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00938-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00939-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00940-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00941-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00942-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00943-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00944-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00945-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00946-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00947-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00948-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00949-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00950-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00951-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00952-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00953-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00954-of-01024": 50,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00955-of-01024": 45,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00956-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00957-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00958-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00959-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00960-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00961-of-01024": 34,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00962-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00963-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00964-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00965-of-01024": 27,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00966-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00967-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00968-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00969-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00970-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00971-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00972-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00973-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00974-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00975-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00976-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00977-of-01024": 46,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00978-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00979-of-01024": 35,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00980-of-01024": 37,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00981-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00982-of-01024": 25,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00983-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00984-of-01024": 42,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00985-of-01024": 25,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00986-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00987-of-01024": 29,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00988-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00989-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00990-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00991-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00992-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00993-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00994-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00995-of-01024": 40,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00996-of-01024": 48,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00997-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00998-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-00999-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01000-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01001-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01002-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01003-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01004-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01005-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01006-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01007-of-01024": 31,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01008-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01009-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01010-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01011-of-01024": 47,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01012-of-01024": 38,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01013-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01014-of-01024": 36,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01015-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01016-of-01024": 44,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01017-of-01024": 43,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01018-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01019-of-01024": 41,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01020-of-01024": 39,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01021-of-01024": 30,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01022-of-01024": 32,
    "bc_z_0.1.0/0.1.0/bc_z-train.tfrecord-01023-of-01024": 33,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00000-of-00064": 61,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00001-of-00064": 53,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00002-of-00064": 59,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00003-of-00064": 62,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00004-of-00064": 56,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00005-of-00064": 57,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00006-of-00064": 66,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00007-of-00064": 59,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00008-of-00064": 53,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00009-of-00064": 67,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00010-of-00064": 61,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00011-of-00064": 59,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00012-of-00064": 79,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00013-of-00064": 60,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00014-of-00064": 54,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00015-of-00064": 62,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00016-of-00064": 59,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00017-of-00064": 64,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00018-of-00064": 65,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00019-of-00064": 57,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00020-of-00064": 61,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00021-of-00064": 56,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00022-of-00064": 61,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00023-of-00064": 58,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00024-of-00064": 66,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00025-of-00064": 64,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00026-of-00064": 62,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00027-of-00064": 60,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00028-of-00064": 45,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00029-of-00064": 62,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00030-of-00064": 56,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00031-of-00064": 83,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00032-of-00064": 63,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00033-of-00064": 55,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00034-of-00064": 59,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00035-of-00064": 61,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00036-of-00064": 62,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00037-of-00064": 68,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00038-of-00064": 56,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00039-of-00064": 63,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00040-of-00064": 60,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00041-of-00064": 66,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00042-of-00064": 63,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00043-of-00064": 65,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00044-of-00064": 60,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00045-of-00064": 74,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00046-of-00064": 55,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00047-of-00064": 75,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00048-of-00064": 56,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00049-of-00064": 71,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00050-of-00064": 65,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00051-of-00064": 58,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00052-of-00064": 58,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00053-of-00064": 54,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00054-of-00064": 73,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00055-of-00064": 65,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00056-of-00064": 70,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00057-of-00064": 49,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00058-of-00064": 50,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00059-of-00064": 64,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00060-of-00064": 62,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00061-of-00064": 59,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00062-of-00064": 49,
    "bc_z_0.1.0/0.1.0/bc_z-val.tfrecord-00063-of-00064": 59,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00000-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00001-of-00124": 6,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00002-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00003-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00004-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00005-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00006-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00007-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00008-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00009-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00010-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00011-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00012-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00013-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00014-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00015-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00016-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00017-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00018-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00019-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00020-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00021-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00022-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00023-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00024-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00025-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00026-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00027-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00028-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00029-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00030-of-00124": 7,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00031-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00032-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00033-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00034-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00035-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00036-of-00124": 6,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00037-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00038-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00039-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00040-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00041-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00042-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00043-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00044-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00045-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00046-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00047-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00048-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00049-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00050-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00051-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00052-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00053-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00054-of-00124": 6,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00055-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00056-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00057-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00058-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00059-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00060-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00061-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00062-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00063-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00064-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00065-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00066-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00067-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00068-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00069-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00070-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00071-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00072-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00073-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00074-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00075-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00076-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00077-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00078-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00079-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00080-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00081-of-00124": 7,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00082-of-00124": 6,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00083-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00084-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00085-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00086-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00087-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00088-of-00124": 8,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00089-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00090-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00091-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00092-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00093-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00094-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00095-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00096-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00097-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00098-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00099-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00100-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00101-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00102-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00103-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00104-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00105-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00106-of-00124": 6,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00107-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00108-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00109-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00110-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00111-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00112-of-00124": 7,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00113-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00114-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00115-of-00124": 3,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00116-of-00124": 1,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00117-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00118-of-00124": 6,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00119-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00120-of-00124": 2,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00121-of-00124": 5,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00122-of-00124": 4,
    "berkeley_fanuc_manipulation_0.1.0/0.1.0/berkeley_fanuc_manipulation-train.tfrecord-00123-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00000-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00001-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00002-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00003-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00004-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00005-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00006-of-00124": 7,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00007-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00008-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00009-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00010-of-00124": 7,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00011-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00012-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00013-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00014-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00015-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00016-of-00124": 1,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00017-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00018-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00019-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00020-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00021-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00022-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00023-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00024-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00025-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00026-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00027-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00028-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00029-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00030-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00031-of-00124": 8,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00032-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00033-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00034-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00035-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00036-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00037-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00038-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00039-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00040-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00041-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00042-of-00124": 9,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00043-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00044-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00045-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00046-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00047-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00048-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00049-of-00124": 7,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00050-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00051-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00052-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00053-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00054-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00055-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00056-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00057-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00058-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00059-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00060-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00061-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00062-of-00124": 1,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00063-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00064-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00065-of-00124": 1,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00066-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00067-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00068-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00069-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00070-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00071-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00072-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00073-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00074-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00075-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00076-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00077-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00078-of-00124": 7,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00079-of-00124": 1,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00080-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00081-of-00124": 7,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00082-of-00124": 1,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00083-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00084-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00085-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00086-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00087-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00088-of-00124": 1,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00089-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00090-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00091-of-00124": 1,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00092-of-00124": 1,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00093-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00094-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00095-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00096-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00097-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00098-of-00124": 8,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00099-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00100-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00101-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00102-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00103-of-00124": 1,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00104-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00105-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00106-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00107-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00108-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00109-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00110-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00111-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00112-of-00124": 6,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00113-of-00124": 7,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00114-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00115-of-00124": 1,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00116-of-00124": 2,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00117-of-00124": 5,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00118-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00119-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00120-of-00124": 4,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00121-of-00124": 9,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00122-of-00124": 3,
    "berkeley_mvp_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_mvp_converted_externally_to_rlds-train.tfrecord-00123-of-00124": 5,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00000-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00001-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00002-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00003-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00004-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00005-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00006-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00007-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00008-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00009-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00010-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00011-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00012-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00013-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00014-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00015-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00016-of-00441": 5,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00017-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00018-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00019-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00020-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00021-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00022-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00023-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00024-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00025-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00026-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00027-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00028-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00029-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00030-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00031-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00032-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00033-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00034-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00035-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00036-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00037-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00038-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00039-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00040-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00041-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00042-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00043-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00044-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00045-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00046-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00047-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00048-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00049-of-00441": 6,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00050-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00051-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00052-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00053-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00054-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00055-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00056-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00057-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00058-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00059-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00060-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00061-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00062-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00063-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00064-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00065-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00066-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00067-of-00441": 5,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00068-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00069-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00070-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00071-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00072-of-00441": 5,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00073-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00074-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00075-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00076-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00077-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00078-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00079-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00080-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00081-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00082-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00083-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00084-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00085-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00086-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00087-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00088-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00089-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00090-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00091-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00092-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00093-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00094-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00095-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00096-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00097-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00098-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00099-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00100-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00101-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00102-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00103-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00104-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00105-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00106-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00107-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00108-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00109-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00110-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00111-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00112-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00113-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00114-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00115-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00116-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00117-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00118-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00119-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00120-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00121-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00122-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00123-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00124-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00125-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00126-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00127-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00128-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00129-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00130-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00131-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00132-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00133-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00134-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00135-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00136-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00137-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00138-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00139-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00140-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00141-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00142-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00143-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00144-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00145-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00146-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00147-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00148-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00149-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00150-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00151-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00152-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00153-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00154-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00155-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00156-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00157-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00158-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00159-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00160-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00161-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00162-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00163-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00164-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00165-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00166-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00167-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00168-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00169-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00170-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00171-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00172-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00173-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00174-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00175-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00176-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00177-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00178-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00179-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00180-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00181-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00182-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00183-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00184-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00185-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00186-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00187-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00188-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00189-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00190-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00191-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00192-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00193-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00194-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00195-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00196-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00197-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00198-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00199-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00200-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00201-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00202-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00203-of-00441": 6,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00204-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00205-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00206-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00207-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00208-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00209-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00210-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00211-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00212-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00213-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00214-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00215-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00216-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00217-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00218-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00219-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00220-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00221-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00222-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00223-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00224-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00225-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00226-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00227-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00228-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00229-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00230-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00231-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00232-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00233-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00234-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00235-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00236-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00237-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00238-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00239-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00240-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00241-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00242-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00243-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00244-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00245-of-00441": 5,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00246-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00247-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00248-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00249-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00250-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00251-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00252-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00253-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00254-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00255-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00256-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00257-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00258-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00259-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00260-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00261-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00262-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00263-of-00441": 5,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00264-of-00441": 6,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00265-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00266-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00267-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00268-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00269-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00270-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00271-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00272-of-00441": 5,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00273-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00274-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00275-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00276-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00277-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00278-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00279-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00280-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00281-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00282-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00283-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00284-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00285-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00286-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00287-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00288-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00289-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00290-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00291-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00292-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00293-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00294-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00295-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00296-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00297-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00298-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00299-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00300-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00301-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00302-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00303-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00304-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00305-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00306-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00307-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00308-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00309-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00310-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00311-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00312-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00313-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00314-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00315-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00316-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00317-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00318-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00319-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00320-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00321-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00322-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00323-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00324-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00325-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00326-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00327-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00328-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00329-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00330-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00331-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00332-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00333-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00334-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00335-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00336-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00337-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00338-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00339-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00340-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00341-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00342-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00343-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00344-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00345-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00346-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00347-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00348-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00349-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00350-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00351-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00352-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00353-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00354-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00355-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00356-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00357-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00358-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00359-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00360-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00361-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00362-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00363-of-00441": 5,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00364-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00365-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00366-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00367-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00368-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00369-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00370-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00371-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00372-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00373-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00374-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00375-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00376-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00377-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00378-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00379-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00380-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00381-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00382-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00383-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00384-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00385-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00386-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00387-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00388-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00389-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00390-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00391-of-00441": 6,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00392-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00393-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00394-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00395-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00396-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00397-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00398-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00399-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00400-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00401-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00402-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00403-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00404-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00405-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00406-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00407-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00408-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00409-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00410-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00411-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00412-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00413-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00414-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00415-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00416-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00417-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00418-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00419-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00420-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00421-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00422-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00423-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00424-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00425-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00426-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00427-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00428-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00429-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00430-of-00441": 4,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00431-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00432-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00433-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00434-of-00441": 3,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00435-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00436-of-00441": 1,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00437-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00438-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00439-of-00441": 2,
    "berkeley_rpt_converted_externally_to_rlds_0.1.0/0.1.0/berkeley_rpt_converted_externally_to_rlds-train.tfrecord-00440-of-00441": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00000-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00001-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00002-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00003-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00004-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00005-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00006-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00007-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00008-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00009-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00010-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00011-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00012-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00013-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00014-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00015-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00016-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00017-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00018-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00019-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00020-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00021-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00022-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00023-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00024-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00025-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00026-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00027-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00028-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00029-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00030-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00031-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00032-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00033-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00034-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00035-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00036-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00037-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00038-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00039-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00040-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00041-of-00512": 12,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00042-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00043-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00044-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00045-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00046-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00047-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00048-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00049-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00050-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00051-of-00512": 12,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00052-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00053-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00054-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00055-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00056-of-00512": 1,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00057-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00058-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00059-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00060-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00061-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00062-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00063-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00064-of-00512": 15,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00065-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00066-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00067-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00068-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00069-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00070-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00071-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00072-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00073-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00074-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00075-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00076-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00077-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00078-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00079-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00080-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00081-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00082-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00083-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00084-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00085-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00086-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00087-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00088-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00089-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00090-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00091-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00092-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00093-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00094-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00095-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00096-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00097-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00098-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00099-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00100-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00101-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00102-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00103-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00104-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00105-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00106-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00107-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00108-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00109-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00110-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00111-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00112-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00113-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00114-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00115-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00116-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00117-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00118-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00119-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00120-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00121-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00122-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00123-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00124-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00125-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00126-of-00512": 12,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00127-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00128-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00129-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00130-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00131-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00132-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00133-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00134-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00135-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00136-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00137-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00138-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00139-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00140-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00141-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00142-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00143-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00144-of-00512": 13,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00145-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00146-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00147-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00148-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00149-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00150-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00151-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00152-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00153-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00154-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00155-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00156-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00157-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00158-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00159-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00160-of-00512": 13,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00161-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00162-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00163-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00164-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00165-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00166-of-00512": 12,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00167-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00168-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00169-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00170-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00171-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00172-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00173-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00174-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00175-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00176-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00177-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00178-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00179-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00180-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00181-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00182-of-00512": 14,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00183-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00184-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00185-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00186-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00187-of-00512": 12,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00188-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00189-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00190-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00191-of-00512": 12,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00192-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00193-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00194-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00195-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00196-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00197-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00198-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00199-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00200-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00201-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00202-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00203-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00204-of-00512": 12,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00205-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00206-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00207-of-00512": 13,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00208-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00209-of-00512": 15,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00210-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00211-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00212-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00213-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00214-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00215-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00216-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00217-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00218-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00219-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00220-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00221-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00222-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00223-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00224-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00225-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00226-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00227-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00228-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00229-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00230-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00231-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00232-of-00512": 14,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00233-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00234-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00235-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00236-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00237-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00238-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00239-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00240-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00241-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00242-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00243-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00244-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00245-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00246-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00247-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00248-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00249-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00250-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00251-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00252-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00253-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00254-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00255-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00256-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00257-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00258-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00259-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00260-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00261-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00262-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00263-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00264-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00265-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00266-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00267-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00268-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00269-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00270-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00271-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00272-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00273-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00274-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00275-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00276-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00277-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00278-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00279-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00280-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00281-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00282-of-00512": 13,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00283-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00284-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00285-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00286-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00287-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00288-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00289-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00290-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00291-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00292-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00293-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00294-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00295-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00296-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00297-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00298-of-00512": 1,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00299-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00300-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00301-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00302-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00303-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00304-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00305-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00306-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00307-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00308-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00309-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00310-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00311-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00312-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00313-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00314-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00315-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00316-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00317-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00318-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00319-of-00512": 1,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00320-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00321-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00322-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00323-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00324-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00325-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00326-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00327-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00328-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00329-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00330-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00331-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00332-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00333-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00334-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00335-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00336-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00337-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00338-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00339-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00340-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00341-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00342-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00343-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00344-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00345-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00346-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00347-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00348-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00349-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00350-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00351-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00352-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00353-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00354-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00355-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00356-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00357-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00358-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00359-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00360-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00361-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00362-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00363-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00364-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00365-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00366-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00367-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00368-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00369-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00370-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00371-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00372-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00373-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00374-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00375-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00376-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00377-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00378-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00379-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00380-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00381-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00382-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00383-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00384-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00385-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00386-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00387-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00388-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00389-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00390-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00391-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00392-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00393-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00394-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00395-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00396-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00397-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00398-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00399-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00400-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00401-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00402-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00403-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00404-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00405-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00406-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00407-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00408-of-00512": 13,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00409-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00410-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00411-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00412-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00413-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00414-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00415-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00416-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00417-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00418-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00419-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00420-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00421-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00422-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00423-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00424-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00425-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00426-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00427-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00428-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00429-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00430-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00431-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00432-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00433-of-00512": 13,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00434-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00435-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00436-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00437-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00438-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00439-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00440-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00441-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00442-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00443-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00444-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00445-of-00512": 13,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00446-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00447-of-00512": 12,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00448-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00449-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00450-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00451-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00452-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00453-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00454-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00455-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00456-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00457-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00458-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00459-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00460-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00461-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00462-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00463-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00464-of-00512": 2,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00465-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00466-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00467-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00468-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00469-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00470-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00471-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00472-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00473-of-00512": 13,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00474-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00475-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00476-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00477-of-00512": 12,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00478-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00479-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00480-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00481-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00482-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00483-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00484-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00485-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00486-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00487-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00488-of-00512": 10,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00489-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00490-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00491-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00492-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00493-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00494-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00495-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00496-of-00512": 1,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00497-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00498-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00499-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00500-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00501-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00502-of-00512": 5,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00503-of-00512": 11,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00504-of-00512": 3,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00505-of-00512": 4,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00506-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00507-of-00512": 7,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00508-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00509-of-00512": 6,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00510-of-00512": 8,
    "bridge_0.1.0/0.1.0/bridge-test.tfrecord-00511-of-00512": 9,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00000-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00001-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00002-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00003-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00004-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00005-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00006-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00007-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00008-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00009-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00010-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00011-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00012-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00013-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00014-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00015-of-01024": 14,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00016-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00017-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00018-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00019-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00020-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00021-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00022-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00023-of-01024": 15,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00024-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00025-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00026-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00027-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00028-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00029-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00030-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00031-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00032-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00033-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00034-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00035-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00036-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00037-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00038-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00039-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00040-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00041-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00042-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00043-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00044-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00045-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00046-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00047-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00048-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00049-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00050-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00051-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00052-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00053-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00054-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00055-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00056-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00057-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00058-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00059-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00060-of-01024": 14,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00061-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00062-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00063-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00064-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00065-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00066-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00067-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00068-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00069-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00070-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00071-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00072-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00073-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00074-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00075-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00076-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00077-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00078-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00079-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00080-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00081-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00082-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00083-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00084-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00085-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00086-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00087-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00088-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00089-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00090-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00091-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00092-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00093-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00094-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00095-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00096-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00097-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00098-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00099-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00100-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00101-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00102-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00103-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00104-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00105-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00106-of-01024": 40,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00107-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00108-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00109-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00110-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00111-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00112-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00113-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00114-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00115-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00116-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00117-of-01024": 14,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00118-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00119-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00120-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00121-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00122-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00123-of-01024": 36,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00124-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00125-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00126-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00127-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00128-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00129-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00130-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00131-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00132-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00133-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00134-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00135-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00136-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00137-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00138-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00139-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00140-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00141-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00142-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00143-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00144-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00145-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00146-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00147-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00148-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00149-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00150-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00151-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00152-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00153-of-01024": 15,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00154-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00155-of-01024": 14,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00156-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00157-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00158-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00159-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00160-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00161-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00162-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00163-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00164-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00165-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00166-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00167-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00168-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00169-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00170-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00171-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00172-of-01024": 14,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00173-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00174-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00175-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00176-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00177-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00178-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00179-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00180-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00181-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00182-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00183-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00184-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00185-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00186-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00187-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00188-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00189-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00190-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00191-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00192-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00193-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00194-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00195-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00196-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00197-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00198-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00199-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00200-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00201-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00202-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00203-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00204-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00205-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00206-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00207-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00208-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00209-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00210-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00211-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00212-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00213-of-01024": 15,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00214-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00215-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00216-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00217-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00218-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00219-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00220-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00221-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00222-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00223-of-01024": 13,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00224-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00225-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00226-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00227-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00228-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00229-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00230-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00231-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00232-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00233-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00234-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00235-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00236-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00237-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00238-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00239-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00240-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00241-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00242-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00243-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00244-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00245-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00246-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00247-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00248-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00249-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00250-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00251-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00252-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00253-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00254-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00255-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00256-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00257-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00258-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00259-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00260-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00261-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00262-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00263-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00264-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00265-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00266-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00267-of-01024": 12,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00268-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00269-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00270-of-01024": 36,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00271-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00272-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00273-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00274-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00275-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00276-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00277-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00278-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00279-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00280-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00281-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00282-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00283-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00284-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00285-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00286-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00287-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00288-of-01024": 41,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00289-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00290-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00291-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00292-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00293-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00294-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00295-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00296-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00297-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00298-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00299-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00300-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00301-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00302-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00303-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00304-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00305-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00306-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00307-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00308-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00309-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00310-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00311-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00312-of-01024": 36,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00313-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00314-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00315-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00316-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00317-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00318-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00319-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00320-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00321-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00322-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00323-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00324-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00325-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00326-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00327-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00328-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00329-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00330-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00331-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00332-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00333-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00334-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00335-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00336-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00337-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00338-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00339-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00340-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00341-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00342-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00343-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00344-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00345-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00346-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00347-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00348-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00349-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00350-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00351-of-01024": 15,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00352-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00353-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00354-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00355-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00356-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00357-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00358-of-01024": 14,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00359-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00360-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00361-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00362-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00363-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00364-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00365-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00366-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00367-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00368-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00369-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00370-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00371-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00372-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00373-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00374-of-01024": 15,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00375-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00376-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00377-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00378-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00379-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00380-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00381-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00382-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00383-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00384-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00385-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00386-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00387-of-01024": 15,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00388-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00389-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00390-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00391-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00392-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00393-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00394-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00395-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00396-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00397-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00398-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00399-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00400-of-01024": 38,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00401-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00402-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00403-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00404-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00405-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00406-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00407-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00408-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00409-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00410-of-01024": 38,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00411-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00412-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00413-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00414-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00415-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00416-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00417-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00418-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00419-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00420-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00421-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00422-of-01024": 13,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00423-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00424-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00425-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00426-of-01024": 15,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00427-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00428-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00429-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00430-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00431-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00432-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00433-of-01024": 36,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00434-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00435-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00436-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00437-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00438-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00439-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00440-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00441-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00442-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00443-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00444-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00445-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00446-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00447-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00448-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00449-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00450-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00451-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00452-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00453-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00454-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00455-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00456-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00457-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00458-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00459-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00460-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00461-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00462-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00463-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00464-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00465-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00466-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00467-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00468-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00469-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00470-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00471-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00472-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00473-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00474-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00475-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00476-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00477-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00478-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00479-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00480-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00481-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00482-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00483-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00484-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00485-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00486-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00487-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00488-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00489-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00490-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00491-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00492-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00493-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00494-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00495-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00496-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00497-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00498-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00499-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00500-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00501-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00502-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00503-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00504-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00505-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00506-of-01024": 13,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00507-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00508-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00509-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00510-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00511-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00512-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00513-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00514-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00515-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00516-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00517-of-01024": 14,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00518-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00519-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00520-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00521-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00522-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00523-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00524-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00525-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00526-of-01024": 39,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00527-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00528-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00529-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00530-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00531-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00532-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00533-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00534-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00535-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00536-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00537-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00538-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00539-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00540-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00541-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00542-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00543-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00544-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00545-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00546-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00547-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00548-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00549-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00550-of-01024": 36,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00551-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00552-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00553-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00554-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00555-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00556-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00557-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00558-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00559-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00560-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00561-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00562-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00563-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00564-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00565-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00566-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00567-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00568-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00569-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00570-of-01024": 36,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00571-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00572-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00573-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00574-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00575-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00576-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00577-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00578-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00579-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00580-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00581-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00582-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00583-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00584-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00585-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00586-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00587-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00588-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00589-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00590-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00591-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00592-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00593-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00594-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00595-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00596-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00597-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00598-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00599-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00600-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00601-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00602-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00603-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00604-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00605-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00606-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00607-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00608-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00609-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00610-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00611-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00612-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00613-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00614-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00615-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00616-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00617-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00618-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00619-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00620-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00621-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00622-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00623-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00624-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00625-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00626-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00627-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00628-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00629-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00630-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00631-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00632-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00633-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00634-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00635-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00636-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00637-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00638-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00639-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00640-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00641-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00642-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00643-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00644-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00645-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00646-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00647-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00648-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00649-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00650-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00651-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00652-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00653-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00654-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00655-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00656-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00657-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00658-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00659-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00660-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00661-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00662-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00663-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00664-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00665-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00666-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00667-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00668-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00669-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00670-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00671-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00672-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00673-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00674-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00675-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00676-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00677-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00678-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00679-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00680-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00681-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00682-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00683-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00684-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00685-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00686-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00687-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00688-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00689-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00690-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00691-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00692-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00693-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00694-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00695-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00696-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00697-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00698-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00699-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00700-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00701-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00702-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00703-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00704-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00705-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00706-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00707-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00708-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00709-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00710-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00711-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00712-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00713-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00714-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00715-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00716-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00717-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00718-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00719-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00720-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00721-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00722-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00723-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00724-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00725-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00726-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00727-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00728-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00729-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00730-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00731-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00732-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00733-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00734-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00735-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00736-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00737-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00738-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00739-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00740-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00741-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00742-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00743-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00744-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00745-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00746-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00747-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00748-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00749-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00750-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00751-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00752-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00753-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00754-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00755-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00756-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00757-of-01024": 15,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00758-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00759-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00760-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00761-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00762-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00763-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00764-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00765-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00766-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00767-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00768-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00769-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00770-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00771-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00772-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00773-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00774-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00775-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00776-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00777-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00778-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00779-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00780-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00781-of-01024": 12,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00782-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00783-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00784-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00785-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00786-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00787-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00788-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00789-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00790-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00791-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00792-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00793-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00794-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00795-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00796-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00797-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00798-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00799-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00800-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00801-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00802-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00803-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00804-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00805-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00806-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00807-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00808-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00809-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00810-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00811-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00812-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00813-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00814-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00815-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00816-of-01024": 11,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00817-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00818-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00819-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00820-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00821-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00822-of-01024": 38,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00823-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00824-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00825-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00826-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00827-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00828-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00829-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00830-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00831-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00832-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00833-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00834-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00835-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00836-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00837-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00838-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00839-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00840-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00841-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00842-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00843-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00844-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00845-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00846-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00847-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00848-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00849-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00850-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00851-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00852-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00853-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00854-of-01024": 36,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00855-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00856-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00857-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00858-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00859-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00860-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00861-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00862-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00863-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00864-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00865-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00866-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00867-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00868-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00869-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00870-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00871-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00872-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00873-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00874-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00875-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00876-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00877-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00878-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00879-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00880-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00881-of-01024": 42,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00882-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00883-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00884-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00885-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00886-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00887-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00888-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00889-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00890-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00891-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00892-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00893-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00894-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00895-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00896-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00897-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00898-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00899-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00900-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00901-of-01024": 15,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00902-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00903-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00904-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00905-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00906-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00907-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00908-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00909-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00910-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00911-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00912-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00913-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00914-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00915-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00916-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00917-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00918-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00919-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00920-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00921-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00922-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00923-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00924-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00925-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00926-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00927-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00928-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00929-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00930-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00931-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00932-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00933-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00934-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00935-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00936-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00937-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00938-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00939-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00940-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00941-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00942-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00943-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00944-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00945-of-01024": 37,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00946-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00947-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00948-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00949-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00950-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00951-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00952-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00953-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00954-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00955-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00956-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00957-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00958-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00959-of-01024": 16,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00960-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00961-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00962-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00963-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00964-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00965-of-01024": 33,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00966-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00967-of-01024": 17,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00968-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00969-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00970-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00971-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00972-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00973-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00974-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00975-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00976-of-01024": 18,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00977-of-01024": 35,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00978-of-01024": 15,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00979-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00980-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00981-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00982-of-01024": 30,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00983-of-01024": 20,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00984-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00985-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00986-of-01024": 31,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00987-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00988-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00989-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00990-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00991-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00992-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00993-of-01024": 21,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00994-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00995-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00996-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00997-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00998-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-00999-of-01024": 36,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01000-of-01024": 19,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01001-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01002-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01003-of-01024": 25,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01004-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01005-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01006-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01007-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01008-of-01024": 27,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01009-of-01024": 34,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01010-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01011-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01012-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01013-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01014-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01015-of-01024": 28,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01016-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01017-of-01024": 22,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01018-of-01024": 29,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01019-of-01024": 23,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01020-of-01024": 24,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01021-of-01024": 32,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01022-of-01024": 26,
    "bridge_0.1.0/0.1.0/bridge-train.tfrecord-01023-of-01024": 22,
    "cmu_franka_exploration_dataset_converted_externally_to_rlds_0.1.0/0.1.0/cmu_franka_exploration_dataset_converted_externally_to_rlds-train.tfrecord-00000-of-00008": 31,
    "cmu_franka_exploration_dataset_converted_externally_to_rlds_0.1.0/0.1.0/cmu_franka_exploration_dataset_converted_externally_to_rlds-train.tfrecord-00001-of-00008": 17,
    "cmu_franka_exploration_dataset_converted_externally_to_rlds_0.1.0/0.1.0/cmu_franka_exploration_dataset_converted_externally_to_rlds-train.tfrecord-00002-of-00008": 17,
    "cmu_franka_exploration_dataset_converted_externally_to_rlds_0.1.0/0.1.0/cmu_franka_exploration_dataset_converted_externally_to_rlds-train.tfrecord-00003-of-00008": 23,
    "cmu_franka_exploration_dataset_converted_externally_to_rlds_0.1.0/0.1.0/cmu_franka_exploration_dataset_converted_externally_to_rlds-train.tfrecord-00004-of-00008": 33,
    "cmu_franka_exploration_dataset_converted_externally_to_rlds_0.1.0/0.1.0/cmu_franka_exploration_dataset_converted_externally_to_rlds-train.tfrecord-00005-of-00008": 28,
    "cmu_franka_exploration_dataset_converted_externally_to_rlds_0.1.0/0.1.0/cmu_franka_exploration_dataset_converted_externally_to_rlds-train.tfrecord-00006-of-00008": 23,
    "cmu_franka_exploration_dataset_converted_externally_to_rlds_0.1.0/0.1.0/cmu_franka_exploration_dataset_converted_externally_to_rlds-train.tfrecord-00007-of-00008": 27,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00000-of-00064": 9,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00001-of-00064": 5,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00002-of-00064": 5,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00003-of-00064": 10,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00004-of-00064": 13,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00005-of-00064": 9,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00006-of-00064": 6,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00007-of-00064": 5,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00008-of-00064": 10,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00009-of-00064": 8,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00010-of-00064": 8,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00011-of-00064": 8,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00012-of-00064": 9,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00013-of-00064": 8,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00014-of-00064": 14,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00015-of-00064": 13,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00016-of-00064": 8,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00017-of-00064": 10,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00018-of-00064": 11,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00019-of-00064": 7,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00020-of-00064": 10,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00021-of-00064": 12,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00022-of-00064": 7,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00023-of-00064": 4,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00024-of-00064": 10,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00025-of-00064": 9,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00026-of-00064": 10,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00027-of-00064": 6,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00028-of-00064": 8,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00029-of-00064": 10,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00030-of-00064": 10,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00031-of-00064": 11,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00032-of-00064": 12,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00033-of-00064": 13,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00034-of-00064": 11,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00035-of-00064": 7,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00036-of-00064": 14,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00037-of-00064": 10,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00038-of-00064": 13,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00039-of-00064": 8,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00040-of-00064": 8,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00041-of-00064": 9,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00042-of-00064": 12,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00043-of-00064": 5,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00044-of-00064": 11,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00045-of-00064": 8,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00046-of-00064": 14,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00047-of-00064": 9,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00048-of-00064": 7,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00049-of-00064": 7,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00050-of-00064": 11,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00051-of-00064": 11,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00052-of-00064": 9,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00053-of-00064": 9,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00054-of-00064": 4,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00055-of-00064": 4,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00056-of-00064": 5,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00057-of-00064": 11,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00058-of-00064": 13,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00059-of-00064": 7,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00060-of-00064": 12,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00061-of-00064": 2,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00062-of-00064": 9,
    "cmu_play_fusion_0.1.0/0.1.0/cmu_play_fusion-train.tfrecord-00063-of-00064": 8,
    "cmu_stretch_0.1.0/0.1.0/cmu_stretch-train.tfrecord-00000-of-00008": 27,
    "cmu_stretch_0.1.0/0.1.0/cmu_stretch-train.tfrecord-00001-of-00008": 14,
    "cmu_stretch_0.1.0/0.1.0/cmu_stretch-train.tfrecord-00002-of-00008": 17,
    "cmu_stretch_0.1.0/0.1.0/cmu_stretch-train.tfrecord-00003-of-00008": 14,
    "cmu_stretch_0.1.0/0.1.0/cmu_stretch-train.tfrecord-00004-of-00008": 20,
    "cmu_stretch_0.1.0/0.1.0/cmu_stretch-train.tfrecord-00005-of-00008": 20,
    "cmu_stretch_0.1.0/0.1.0/cmu_stretch-train.tfrecord-00006-of-00008": 16,
    "cmu_stretch_0.1.0/0.1.0/cmu_stretch-train.tfrecord-00007-of-00008": 7,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00000-of-00029": 2,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00001-of-00029": 4,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00002-of-00029": 6,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00003-of-00029": 1,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00004-of-00029": 3,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00005-of-00029": 2,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00006-of-00029": 2,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00007-of-00029": 2,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00008-of-00029": 6,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00009-of-00029": 4,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00010-of-00029": 1,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00011-of-00029": 5,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00012-of-00029": 3,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00013-of-00029": 5,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00014-of-00029": 1,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00015-of-00029": 3,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00016-of-00029": 1,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00017-of-00029": 4,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00018-of-00029": 3,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00019-of-00029": 7,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00020-of-00029": 5,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00021-of-00029": 5,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00022-of-00029": 6,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00023-of-00029": 6,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00024-of-00029": 4,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00025-of-00029": 3,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00026-of-00029": 4,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00027-of-00029": 3,
    "dlr_edan_shared_control_converted_externally_to_rlds_0.1.0/0.1.0/dlr_edan_shared_control_converted_externally_to_rlds-train.tfrecord-00028-of-00029": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00000-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00001-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00002-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00003-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00004-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00005-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00006-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00007-of-00053": 4,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00008-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00009-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00010-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00011-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00012-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00013-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00014-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00015-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00016-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00017-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00018-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00019-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00020-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00021-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00022-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00023-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00024-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00025-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00026-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00027-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00028-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00029-of-00053": 7,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00030-of-00053": 4,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00031-of-00053": 5,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00032-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00033-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00034-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00035-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00036-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00037-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00038-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00039-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00040-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00041-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00042-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00043-of-00053": 4,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00044-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00045-of-00053": 1,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00046-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00047-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00048-of-00053": 3,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00049-of-00053": 4,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00050-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00051-of-00053": 2,
    "eth_agent_affordances_0.1.0/0.1.0/eth_agent_affordances-train.tfrecord-00052-of-00053": 4,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00000-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00001-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00002-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00003-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00004-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00005-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00006-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00007-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00008-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00009-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00010-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00011-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00012-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00013-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00014-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00015-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00016-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00017-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00018-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00019-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00020-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00021-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00022-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00023-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00024-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00025-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00026-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00027-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00028-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00029-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00030-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00031-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00032-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00033-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00034-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00035-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00036-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00037-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00038-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00039-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00040-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00041-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00042-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00043-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00044-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00045-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00046-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00047-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00048-of-01024": 66,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00049-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00050-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00051-of-01024": 107,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00052-of-01024": 69,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00053-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00054-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00055-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00056-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00057-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00058-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00059-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00060-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00061-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00062-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00063-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00064-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00065-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00066-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00067-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00068-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00069-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00070-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00071-of-01024": 62,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00072-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00073-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00074-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00075-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00076-of-01024": 72,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00077-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00078-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00079-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00080-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00081-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00082-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00083-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00084-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00085-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00086-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00087-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00088-of-01024": 103,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00089-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00090-of-01024": 108,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00091-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00092-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00093-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00094-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00095-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00096-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00097-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00098-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00099-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00100-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00101-of-01024": 100,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00102-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00103-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00104-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00105-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00106-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00107-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00108-of-01024": 100,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00109-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00110-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00111-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00112-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00113-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00114-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00115-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00116-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00117-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00118-of-01024": 99,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00119-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00120-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00121-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00122-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00123-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00124-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00125-of-01024": 103,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00126-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00127-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00128-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00129-of-01024": 65,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00130-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00131-of-01024": 100,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00132-of-01024": 100,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00133-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00134-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00135-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00136-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00137-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00138-of-01024": 104,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00139-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00140-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00141-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00142-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00143-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00144-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00145-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00146-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00147-of-01024": 100,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00148-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00149-of-01024": 66,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00150-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00151-of-01024": 99,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00152-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00153-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00154-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00155-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00156-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00157-of-01024": 72,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00158-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00159-of-01024": 66,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00160-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00161-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00162-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00163-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00164-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00165-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00166-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00167-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00168-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00169-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00170-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00171-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00172-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00173-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00174-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00175-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00176-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00177-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00178-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00179-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00180-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00181-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00182-of-01024": 99,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00183-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00184-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00185-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00186-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00187-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00188-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00189-of-01024": 60,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00190-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00191-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00192-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00193-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00194-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00195-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00196-of-01024": 66,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00197-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00198-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00199-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00200-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00201-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00202-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00203-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00204-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00205-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00206-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00207-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00208-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00209-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00210-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00211-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00212-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00213-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00214-of-01024": 102,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00215-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00216-of-01024": 106,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00217-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00218-of-01024": 69,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00219-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00220-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00221-of-01024": 104,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00222-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00223-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00224-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00225-of-01024": 106,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00226-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00227-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00228-of-01024": 103,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00229-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00230-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00231-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00232-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00233-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00234-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00235-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00236-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00237-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00238-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00239-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00240-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00241-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00242-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00243-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00244-of-01024": 100,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00245-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00246-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00247-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00248-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00249-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00250-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00251-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00252-of-01024": 100,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00253-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00254-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00255-of-01024": 100,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00256-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00257-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00258-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00259-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00260-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00261-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00262-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00263-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00264-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00265-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00266-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00267-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00268-of-01024": 72,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00269-of-01024": 103,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00270-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00271-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00272-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00273-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00274-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00275-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00276-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00277-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00278-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00279-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00280-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00281-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00282-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00283-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00284-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00285-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00286-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00287-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00288-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00289-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00290-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00291-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00292-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00293-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00294-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00295-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00296-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00297-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00298-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00299-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00300-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00301-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00302-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00303-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00304-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00305-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00306-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00307-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00308-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00309-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00310-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00311-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00312-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00313-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00314-of-01024": 105,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00315-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00316-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00317-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00318-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00319-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00320-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00321-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00322-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00323-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00324-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00325-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00326-of-01024": 104,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00327-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00328-of-01024": 69,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00329-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00330-of-01024": 103,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00331-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00332-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00333-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00334-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00335-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00336-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00337-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00338-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00339-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00340-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00341-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00342-of-01024": 72,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00343-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00344-of-01024": 99,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00345-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00346-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00347-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00348-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00349-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00350-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00351-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00352-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00353-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00354-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00355-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00356-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00357-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00358-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00359-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00360-of-01024": 67,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00361-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00362-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00363-of-01024": 72,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00364-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00365-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00366-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00367-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00368-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00369-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00370-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00371-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00372-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00373-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00374-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00375-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00376-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00377-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00378-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00379-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00380-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00381-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00382-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00383-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00384-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00385-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00386-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00387-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00388-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00389-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00390-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00391-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00392-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00393-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00394-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00395-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00396-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00397-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00398-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00399-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00400-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00401-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00402-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00403-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00404-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00405-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00406-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00407-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00408-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00409-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00410-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00411-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00412-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00413-of-01024": 104,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00414-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00415-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00416-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00417-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00418-of-01024": 65,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00419-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00420-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00421-of-01024": 63,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00422-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00423-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00424-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00425-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00426-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00427-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00428-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00429-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00430-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00431-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00432-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00433-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00434-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00435-of-01024": 105,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00436-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00437-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00438-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00439-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00440-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00441-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00442-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00443-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00444-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00445-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00446-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00447-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00448-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00449-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00450-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00451-of-01024": 69,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00452-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00453-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00454-of-01024": 63,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00455-of-01024": 65,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00456-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00457-of-01024": 66,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00458-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00459-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00460-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00461-of-01024": 68,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00462-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00463-of-01024": 105,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00464-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00465-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00466-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00467-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00468-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00469-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00470-of-01024": 112,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00471-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00472-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00473-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00474-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00475-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00476-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00477-of-01024": 59,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00478-of-01024": 99,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00479-of-01024": 105,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00480-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00481-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00482-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00483-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00484-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00485-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00486-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00487-of-01024": 99,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00488-of-01024": 72,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00489-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00490-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00491-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00492-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00493-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00494-of-01024": 102,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00495-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00496-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00497-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00498-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00499-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00500-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00501-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00502-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00503-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00504-of-01024": 67,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00505-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00506-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00507-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00508-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00509-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00510-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00511-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00512-of-01024": 62,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00513-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00514-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00515-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00516-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00517-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00518-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00519-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00520-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00521-of-01024": 69,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00522-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00523-of-01024": 68,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00524-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00525-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00526-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00527-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00528-of-01024": 72,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00529-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00530-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00531-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00532-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00533-of-01024": 104,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00534-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00535-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00536-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00537-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00538-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00539-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00540-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00541-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00542-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00543-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00544-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00545-of-01024": 64,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00546-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00547-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00548-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00549-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00550-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00551-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00552-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00553-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00554-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00555-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00556-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00557-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00558-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00559-of-01024": 64,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00560-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00561-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00562-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00563-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00564-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00565-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00566-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00567-of-01024": 69,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00568-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00569-of-01024": 67,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00570-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00571-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00572-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00573-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00574-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00575-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00576-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00577-of-01024": 69,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00578-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00579-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00580-of-01024": 103,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00581-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00582-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00583-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00584-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00585-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00586-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00587-of-01024": 68,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00588-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00589-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00590-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00591-of-01024": 104,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00592-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00593-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00594-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00595-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00596-of-01024": 113,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00597-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00598-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00599-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00600-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00601-of-01024": 102,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00602-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00603-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00604-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00605-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00606-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00607-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00608-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00609-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00610-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00611-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00612-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00613-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00614-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00615-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00616-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00617-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00618-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00619-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00620-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00621-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00622-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00623-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00624-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00625-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00626-of-01024": 69,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00627-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00628-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00629-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00630-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00631-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00632-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00633-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00634-of-01024": 72,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00635-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00636-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00637-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00638-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00639-of-01024": 99,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00640-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00641-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00642-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00643-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00644-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00645-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00646-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00647-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00648-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00649-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00650-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00651-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00652-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00653-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00654-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00655-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00656-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00657-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00658-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00659-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00660-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00661-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00662-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00663-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00664-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00665-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00666-of-01024": 99,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00667-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00668-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00669-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00670-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00671-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00672-of-01024": 99,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00673-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00674-of-01024": 60,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00675-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00676-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00677-of-01024": 111,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00678-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00679-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00680-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00681-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00682-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00683-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00684-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00685-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00686-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00687-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00688-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00689-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00690-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00691-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00692-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00693-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00694-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00695-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00696-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00697-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00698-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00699-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00700-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00701-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00702-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00703-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00704-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00705-of-01024": 100,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00706-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00707-of-01024": 72,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00708-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00709-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00710-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00711-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00712-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00713-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00714-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00715-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00716-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00717-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00718-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00719-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00720-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00721-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00722-of-01024": 63,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00723-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00724-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00725-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00726-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00727-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00728-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00729-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00730-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00731-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00732-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00733-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00734-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00735-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00736-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00737-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00738-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00739-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00740-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00741-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00742-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00743-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00744-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00745-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00746-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00747-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00748-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00749-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00750-of-01024": 112,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00751-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00752-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00753-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00754-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00755-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00756-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00757-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00758-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00759-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00760-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00761-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00762-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00763-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00764-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00765-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00766-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00767-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00768-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00769-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00770-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00771-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00772-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00773-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00774-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00775-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00776-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00777-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00778-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00779-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00780-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00781-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00782-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00783-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00784-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00785-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00786-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00787-of-01024": 106,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00788-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00789-of-01024": 66,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00790-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00791-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00792-of-01024": 57,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00793-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00794-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00795-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00796-of-01024": 99,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00797-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00798-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00799-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00800-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00801-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00802-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00803-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00804-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00805-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00806-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00807-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00808-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00809-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00810-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00811-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00812-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00813-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00814-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00815-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00816-of-01024": 103,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00817-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00818-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00819-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00820-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00821-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00822-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00823-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00824-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00825-of-01024": 75,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00826-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00827-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00828-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00829-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00830-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00831-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00832-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00833-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00834-of-01024": 68,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00835-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00836-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00837-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00838-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00839-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00840-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00841-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00842-of-01024": 66,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00843-of-01024": 106,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00844-of-01024": 114,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00845-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00846-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00847-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00848-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00849-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00850-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00851-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00852-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00853-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00854-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00855-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00856-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00857-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00858-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00859-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00860-of-01024": 102,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00861-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00862-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00863-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00864-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00865-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00866-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00867-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00868-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00869-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00870-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00871-of-01024": 67,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00872-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00873-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00874-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00875-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00876-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00877-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00878-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00879-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00880-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00881-of-01024": 72,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00882-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00883-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00884-of-01024": 93,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00885-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00886-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00887-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00888-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00889-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00890-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00891-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00892-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00893-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00894-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00895-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00896-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00897-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00898-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00899-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00900-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00901-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00902-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00903-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00904-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00905-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00906-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00907-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00908-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00909-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00910-of-01024": 120,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00911-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00912-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00913-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00914-of-01024": 69,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00915-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00916-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00917-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00918-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00919-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00920-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00921-of-01024": 99,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00922-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00923-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00924-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00925-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00926-of-01024": 68,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00927-of-01024": 106,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00928-of-01024": 97,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00929-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00930-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00931-of-01024": 105,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00932-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00933-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00934-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00935-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00936-of-01024": 106,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00937-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00938-of-01024": 66,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00939-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00940-of-01024": 69,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00941-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00942-of-01024": 79,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00943-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00944-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00945-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00946-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00947-of-01024": 77,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00948-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00949-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00950-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00951-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00952-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00953-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00954-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00955-of-01024": 68,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00956-of-01024": 82,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00957-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00958-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00959-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00960-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00961-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00962-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00963-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00964-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00965-of-01024": 78,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00966-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00967-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00968-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00969-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00970-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00971-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00972-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00973-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00974-of-01024": 101,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00975-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00976-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00977-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00978-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00979-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00980-of-01024": 65,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00981-of-01024": 107,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00982-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00983-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00984-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00985-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00986-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00987-of-01024": 81,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00988-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00989-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00990-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00991-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00992-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00993-of-01024": 94,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00994-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00995-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00996-of-01024": 76,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00997-of-01024": 91,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00998-of-01024": 73,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-00999-of-01024": 95,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01000-of-01024": 74,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01001-of-01024": 85,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01002-of-01024": 70,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01003-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01004-of-01024": 92,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01005-of-01024": 96,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01006-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01007-of-01024": 83,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01008-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01009-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01010-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01011-of-01024": 71,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01012-of-01024": 88,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01013-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01014-of-01024": 84,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01015-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01016-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01017-of-01024": 86,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01018-of-01024": 80,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01019-of-01024": 98,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01020-of-01024": 87,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01021-of-01024": 89,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01022-of-01024": 90,
    "fractal20220817_data_0.1.0/0.1.0/fractal20220817_data-train.tfrecord-01023-of-01024": 76,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00000-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00001-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00002-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00003-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00004-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00005-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00006-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00007-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00008-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00009-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00010-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00011-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00012-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00013-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00014-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00015-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00016-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00017-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00018-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00019-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00020-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00021-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00022-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00023-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00024-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00025-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00026-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00027-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00028-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00029-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00030-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00031-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00032-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00033-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00034-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00035-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00036-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00037-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00038-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00039-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00040-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00041-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00042-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00043-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00044-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00045-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00046-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00047-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00048-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00049-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00050-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00051-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00052-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00053-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00054-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00055-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00056-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00057-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00058-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00059-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00060-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00061-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00062-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00063-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00064-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00065-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00066-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00067-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00068-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00069-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00070-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00071-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00072-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00073-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00074-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00075-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00076-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00077-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00078-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00079-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00080-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00081-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00082-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00083-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00084-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00085-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00086-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00087-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00088-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00089-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00090-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00091-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00092-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00093-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00094-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00095-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00096-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00097-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00098-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00099-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00100-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00101-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00102-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00103-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00104-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00105-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00106-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00107-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00108-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00109-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00110-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00111-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00112-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00113-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00114-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00115-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00116-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00117-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00118-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00119-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00120-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00121-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00122-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00123-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00124-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00125-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00126-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00127-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00128-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00129-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00130-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00131-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00132-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00133-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00134-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00135-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00136-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00137-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00138-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00139-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00140-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00141-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00142-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00143-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00144-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00145-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00146-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00147-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00148-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00149-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00150-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00151-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00152-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00153-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00154-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00155-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00156-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00157-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00158-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00159-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00160-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00161-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00162-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00163-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00164-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00165-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00166-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00167-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00168-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00169-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00170-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00171-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00172-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00173-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00174-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00175-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00176-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00177-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00178-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00179-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00180-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00181-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00182-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00183-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00184-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00185-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00186-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00187-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00188-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00189-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00190-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00191-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00192-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00193-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00194-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00195-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00196-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00197-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00198-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00199-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00200-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00201-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00202-of-00369": 5,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00203-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00204-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00205-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00206-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00207-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00208-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00209-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00210-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00211-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00212-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00213-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00214-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00215-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00216-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00217-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00218-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00219-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00220-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00221-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00222-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00223-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00224-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00225-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00226-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00227-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00228-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00229-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00230-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00231-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00232-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00233-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00234-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00235-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00236-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00237-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00238-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00239-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00240-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00241-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00242-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00243-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00244-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00245-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00246-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00247-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00248-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00249-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00250-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00251-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00252-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00253-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00254-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00255-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00256-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00257-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00258-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00259-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00260-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00261-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00262-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00263-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00264-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00265-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00266-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00267-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00268-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00269-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00270-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00271-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00272-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00273-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00274-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00275-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00276-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00277-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00278-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00279-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00280-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00281-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00282-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00283-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00284-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00285-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00286-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00287-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00288-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00289-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00290-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00291-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00292-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00293-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00294-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00295-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00296-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00297-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00298-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00299-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00300-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00301-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00302-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00303-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00304-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00305-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00306-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00307-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00308-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00309-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00310-of-00369": 5,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00311-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00312-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00313-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00314-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00315-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00316-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00317-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00318-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00319-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00320-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00321-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00322-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00323-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00324-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00325-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00326-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00327-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00328-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00329-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00330-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00331-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00332-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00333-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00334-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00335-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00336-of-00369": 4,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00337-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00338-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00339-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00340-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00341-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00342-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00343-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00344-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00345-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00346-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00347-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00348-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00349-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00350-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00351-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00352-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00353-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00354-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00355-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00356-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00357-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00358-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00359-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00360-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00361-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00362-of-00369": 2,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00363-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00364-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00365-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00366-of-00369": 1,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00367-of-00369": 3,
    "iamlab_cmu_pickup_insert_converted_externally_to_rlds_0.1.0/0.1.0/iamlab_cmu_pickup_insert_converted_externally_to_rlds-train.tfrecord-00368-of-00369": 4,
    "imperialcollege_sawyer_wrist_cam_0.1.0/0.1.0/imperialcollege_sawyer_wrist_cam-train.tfrecord-00000-of-00001": 170,
    "jaco_play_0.1.0/0.1.0/jaco_play-test.tfrecord-00000-of-00008": 12,
    "jaco_play_0.1.0/0.1.0/jaco_play-test.tfrecord-00001-of-00008": 17,
    "jaco_play_0.1.0/0.1.0/jaco_play-test.tfrecord-00002-of-00008": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-test.tfrecord-00003-of-00008": 12,
    "jaco_play_0.1.0/0.1.0/jaco_play-test.tfrecord-00004-of-00008": 15,
    "jaco_play_0.1.0/0.1.0/jaco_play-test.tfrecord-00005-of-00008": 17,
    "jaco_play_0.1.0/0.1.0/jaco_play-test.tfrecord-00006-of-00008": 13,
    "jaco_play_0.1.0/0.1.0/jaco_play-test.tfrecord-00007-of-00008": 14,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00000-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00001-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00002-of-00128": 4,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00003-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00004-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00005-of-00128": 13,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00006-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00007-of-00128": 12,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00008-of-00128": 4,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00009-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00010-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00011-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00012-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00013-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00014-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00015-of-00128": 3,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00016-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00017-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00018-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00019-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00020-of-00128": 11,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00021-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00022-of-00128": 11,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00023-of-00128": 4,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00024-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00025-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00026-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00027-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00028-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00029-of-00128": 10,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00030-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00031-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00032-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00033-of-00128": 17,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00034-of-00128": 4,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00035-of-00128": 10,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00036-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00037-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00038-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00039-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00040-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00041-of-00128": 10,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00042-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00043-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00044-of-00128": 10,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00045-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00046-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00047-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00048-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00049-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00050-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00051-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00052-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00053-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00054-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00055-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00056-of-00128": 11,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00057-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00058-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00059-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00060-of-00128": 14,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00061-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00062-of-00128": 13,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00063-of-00128": 2,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00064-of-00128": 10,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00065-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00066-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00067-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00068-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00069-of-00128": 10,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00070-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00071-of-00128": 4,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00072-of-00128": 3,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00073-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00074-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00075-of-00128": 11,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00076-of-00128": 3,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00077-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00078-of-00128": 13,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00079-of-00128": 10,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00080-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00081-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00082-of-00128": 10,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00083-of-00128": 10,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00084-of-00128": 15,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00085-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00086-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00087-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00088-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00089-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00090-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00091-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00092-of-00128": 11,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00093-of-00128": 10,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00094-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00095-of-00128": 4,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00096-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00097-of-00128": 13,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00098-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00099-of-00128": 14,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00100-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00101-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00102-of-00128": 1,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00103-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00104-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00105-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00106-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00107-of-00128": 10,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00108-of-00128": 1,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00109-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00110-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00111-of-00128": 9,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00112-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00113-of-00128": 12,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00114-of-00128": 11,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00115-of-00128": 11,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00116-of-00128": 7,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00117-of-00128": 8,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00118-of-00128": 11,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00119-of-00128": 11,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00120-of-00128": 11,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00121-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00122-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00123-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00124-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00125-of-00128": 5,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00126-of-00128": 6,
    "jaco_play_0.1.0/0.1.0/jaco_play-train.tfrecord-00127-of-00128": 6,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00000-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00001-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00002-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00003-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00004-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00005-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00006-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00007-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00008-of-00101": 4,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00009-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00010-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00011-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00012-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00013-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00014-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00015-of-00101": 4,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00016-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00017-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00018-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00019-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00020-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00021-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00022-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00023-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00024-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00025-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00026-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00027-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00028-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00029-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00030-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00031-of-00101": 5,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00032-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00033-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00034-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00035-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00036-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00037-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00038-of-00101": 4,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00039-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00040-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00041-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00042-of-00101": 4,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00043-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00044-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00045-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00046-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00047-of-00101": 5,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00048-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00049-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00050-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00051-of-00101": 5,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00052-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00053-of-00101": 4,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00054-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00055-of-00101": 4,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00056-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00057-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00058-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00059-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00060-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00061-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00062-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00063-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00064-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00065-of-00101": 5,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00066-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00067-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00068-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00069-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00070-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00071-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00072-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00073-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00074-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00075-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00076-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00077-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00078-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00079-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00080-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00081-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00082-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00083-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00084-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00085-of-00101": 2,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00086-of-00101": 4,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00087-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00088-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00089-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00090-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00091-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00092-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00093-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00094-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00095-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00096-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00097-of-00101": 3,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00098-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00099-of-00101": 1,
    "kaist_nonprehensile_converted_externally_to_rlds_0.1.0/0.1.0/kaist_nonprehensile_converted_externally_to_rlds-train.tfrecord-00100-of-00101": 4,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00000": 877,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00001": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00002": 881,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00003": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00004": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00005": 884,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00006": 881,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00007": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00008": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00009": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00010": 883,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00011": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00012": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00013": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00014": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00015": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00016": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00017": 884,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00018": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00019": 877,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00020": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00021": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00022": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00023": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00024": 864,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00025": 867,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00026": 785,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00027": 851,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00028": 836,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00029": 871,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00030": 817,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00031": 804,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00032": 809,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00033": 825,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00034": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00035": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00036": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00037": 883,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00038": 870,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00039": 871,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00040": 866,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00041": 886,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00042": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00043": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00044": 886,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00045": 876,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00046": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00047": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00048": 874,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00049": 866,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00050": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00051": 879,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00052": 886,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00053": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00054": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00055": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00056": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00057": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00058": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00059": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00060": 877,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00061": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00062": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00063": 863,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00064": 850,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00065": 818,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00066": 871,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00067": 812,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00068": 804,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00069": 852,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00070": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00071": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00072": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00073": 875,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00074": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00075": 873,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00076": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00077": 851,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00078": 876,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00079": 876,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00080": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00081": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00082": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00083": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00084": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00085": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00086": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00087": 886,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00088": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00089": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00090": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00091": 876,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00092": 828,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00093": 826,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00094": 818,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00095": 878,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00096": 881,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00097": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00098": 878,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00099": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00100": 880,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00101": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00102": 883,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00103": 881,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00104": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00105": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00106": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00107": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00108": 879,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00109": 857,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00110": 858,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00111": 863,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00112": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00113": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00114": 875,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00115": 875,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00116": 865,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00117": 884,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00118": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00119": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00120": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00121": 879,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00122": 840,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00123": 880,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00124": 726,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00125": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00126": 858,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00127": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00128": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00129": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00130": 886,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00131": 865,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00132": 867,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00133": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00134": 903,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00135": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00136": 759,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00137": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00138": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00139": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00140": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00141": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00142": 805,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00143": 744,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00144": 862,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00145": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00146": 883,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00147": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00148": 829,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00149": 872,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00150": 824,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00151": 878,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00152": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00153": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00154": 827,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00155": 884,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00156": 881,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00157": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00158": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00159": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00160": 883,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00161": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00162": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00163": 864,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00164": 881,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00165": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00166": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00167": 882,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00168": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00169": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00170": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00171": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00172": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00173": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00174": 883,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00175": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00176": 880,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00177": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00178": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00179": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00180": 846,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00181": 876,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00182": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00183": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00184": 868,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00185": 878,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00186": 854,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00187": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00188": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00189": 905,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00190": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00191": 868,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00192": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00193": 882,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00194": 875,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00195": 853,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00196": 881,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00197": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00198": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00199": 886,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00200": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00201": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00202": 883,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00203": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00204": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00205": 881,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00206": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00207": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00208": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00209": 886,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00210": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00211": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00212": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00213": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00214": 902,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00215": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00216": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00217": 874,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00218": 884,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00219": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00220": 886,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00221": 832,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00222": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00223": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00224": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00225": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00226": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00227": 862,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00228": 882,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00229": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00230": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00231": 827,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00232": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00233": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00234": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00235": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00236": 904,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00237": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00238": 903,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00239": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00240": 905,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00241": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00242": 906,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00243": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00244": 906,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00245": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00246": 906,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00247": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00248": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00249": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00250": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00251": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00252": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00253": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00254": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00255": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00256": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00257": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00258": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00259": 876,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00260": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00261": 883,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00262": 876,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00263": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00264": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00265": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00266": 865,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00267": 778,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00268": 820,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00269": 850,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00270": 840,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00271": 872,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00272": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00273": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00274": 902,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00275": 906,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00276": 905,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00277": 903,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00278": 907,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00279": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00280": 908,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00281": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00282": 905,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00283": 908,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00284": 832,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00285": 904,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00286": 907,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00287": 907,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00288": 902,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00289": 905,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00290": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00291": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00292": 908,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00293": 907,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00294": 904,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00295": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00296": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00297": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00298": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00299": 866,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00300": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00301": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00302": 908,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00303": 877,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00304": 844,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00305": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00306": 827,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00307": 871,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00308": 862,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00309": 870,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00310": 858,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00311": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00312": 806,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00313": 838,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00314": 852,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00315": 736,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00316": 868,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00317": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00318": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00319": 838,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00320": 818,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00321": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00322": 906,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00323": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00324": 847,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00325": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00326": 836,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00327": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00328": 877,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00329": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00330": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00331": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00332": 867,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00333": 904,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00334": 907,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00335": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00336": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00337": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00338": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00339": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00340": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00341": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00342": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00343": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00344": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00345": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00346": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00347": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00348": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00349": 903,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00350": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00351": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00352": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00353": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00354": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00355": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00356": 904,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00357": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00358": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00359": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00360": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00361": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00362": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00363": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00364": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00365": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00366": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00367": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00368": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00369": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00370": 883,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00371": 903,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00372": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00373": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00374": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00375": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00376": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00377": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00378": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00379": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00380": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00381": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00382": 902,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00383": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00384": 881,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00385": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00386": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00387": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00388": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00389": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00390": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00391": 881,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00392": 845,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00393": 860,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00394": 886,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00395": 904,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00396": 903,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00397": 904,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00398": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00399": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00400": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00401": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00402": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00403": 908,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00404": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00405": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00406": 903,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00407": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00408": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00409": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00410": 906,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00411": 903,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00412": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00413": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00414": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00415": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00416": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00417": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00418": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00419": 884,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00420": 906,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00421": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00422": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00423": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00424": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00425": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00426": 902,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00427": 904,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00428": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00429": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00430": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00431": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00432": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00433": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00434": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00435": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00436": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00437": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00438": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00439": 856,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00440": 876,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00441": 889,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00442": 903,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00443": 901,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00444": 904,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00445": 903,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00446": 905,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00447": 908,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00448": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00449": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00450": 906,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00451": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00452": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00453": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00454": 903,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00455": 899,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00456": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00457": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00458": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00459": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00460": 885,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00461": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00462": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00463": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00464": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00465": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00466": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00467": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00468": 890,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00469": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00470": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00471": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00472": 884,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00473": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00474": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00475": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00476": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00477": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00478": 895,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00479": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00480": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00481": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00482": 898,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00483": 888,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00484": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00485": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00486": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00487": 886,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00488": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00489": 887,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00490": 902,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00491": 892,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00492": 882,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00493": 893,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00494": 891,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00495": 896,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00496": 897,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00497": 894,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00498": 900,
    "language_table_0.0.1/0.0.1/language_table-train.tfrecord-00499": 798,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00000-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00001-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00002-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00003-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00004-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00005-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00006-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00007-of-01024": 41,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00008-of-01024": 19,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00009-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00010-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00011-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00012-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00013-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00014-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00015-of-01024": 19,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00016-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00017-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00018-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00019-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00020-of-01024": 40,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00021-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00022-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00023-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00024-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00025-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00026-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00027-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00028-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00029-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00030-of-01024": 43,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00031-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00032-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00033-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00034-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00035-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00036-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00037-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00038-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00039-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00040-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00041-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00042-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00043-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00044-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00045-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00046-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00047-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00048-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00049-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00050-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00051-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00052-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00053-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00054-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00055-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00056-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00057-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00058-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00059-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00060-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00061-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00062-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00063-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00064-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00065-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00066-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00067-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00068-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00069-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00070-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00071-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00072-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00073-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00074-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00075-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00076-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00077-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00078-of-01024": 39,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00079-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00080-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00081-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00082-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00083-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00084-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00085-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00086-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00087-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00088-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00089-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00090-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00091-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00092-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00093-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00094-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00095-of-01024": 18,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00096-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00097-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00098-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00099-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00100-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00101-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00102-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00103-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00104-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00105-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00106-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00107-of-01024": 39,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00108-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00109-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00110-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00111-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00112-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00113-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00114-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00115-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00116-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00117-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00118-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00119-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00120-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00121-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00122-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00123-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00124-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00125-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00126-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00127-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00128-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00129-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00130-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00131-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00132-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00133-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00134-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00135-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00136-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00137-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00138-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00139-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00140-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00141-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00142-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00143-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00144-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00145-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00146-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00147-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00148-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00149-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00150-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00151-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00152-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00153-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00154-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00155-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00156-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00157-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00158-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00159-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00160-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00161-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00162-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00163-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00164-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00165-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00166-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00167-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00168-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00169-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00170-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00171-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00172-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00173-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00174-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00175-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00176-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00177-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00178-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00179-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00180-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00181-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00182-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00183-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00184-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00185-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00186-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00187-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00188-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00189-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00190-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00191-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00192-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00193-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00194-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00195-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00196-of-01024": 40,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00197-of-01024": 42,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00198-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00199-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00200-of-01024": 41,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00201-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00202-of-01024": 42,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00203-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00204-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00205-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00206-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00207-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00208-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00209-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00210-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00211-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00212-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00213-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00214-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00215-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00216-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00217-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00218-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00219-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00220-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00221-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00222-of-01024": 41,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00223-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00224-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00225-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00226-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00227-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00228-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00229-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00230-of-01024": 40,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00231-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00232-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00233-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00234-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00235-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00236-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00237-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00238-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00239-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00240-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00241-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00242-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00243-of-01024": 42,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00244-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00245-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00246-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00247-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00248-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00249-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00250-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00251-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00252-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00253-of-01024": 17,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00254-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00255-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00256-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00257-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00258-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00259-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00260-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00261-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00262-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00263-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00264-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00265-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00266-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00267-of-01024": 41,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00268-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00269-of-01024": 40,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00270-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00271-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00272-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00273-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00274-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00275-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00276-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00277-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00278-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00279-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00280-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00281-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00282-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00283-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00284-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00285-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00286-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00287-of-01024": 18,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00288-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00289-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00290-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00291-of-01024": 18,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00292-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00293-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00294-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00295-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00296-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00297-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00298-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00299-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00300-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00301-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00302-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00303-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00304-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00305-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00306-of-01024": 18,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00307-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00308-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00309-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00310-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00311-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00312-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00313-of-01024": 19,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00314-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00315-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00316-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00317-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00318-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00319-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00320-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00321-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00322-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00323-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00324-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00325-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00326-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00327-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00328-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00329-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00330-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00331-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00332-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00333-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00334-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00335-of-01024": 41,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00336-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00337-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00338-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00339-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00340-of-01024": 17,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00341-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00342-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00343-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00344-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00345-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00346-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00347-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00348-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00349-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00350-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00351-of-01024": 43,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00352-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00353-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00354-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00355-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00356-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00357-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00358-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00359-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00360-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00361-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00362-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00363-of-01024": 42,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00364-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00365-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00366-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00367-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00368-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00369-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00370-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00371-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00372-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00373-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00374-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00375-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00376-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00377-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00378-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00379-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00380-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00381-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00382-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00383-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00384-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00385-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00386-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00387-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00388-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00389-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00390-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00391-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00392-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00393-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00394-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00395-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00396-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00397-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00398-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00399-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00400-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00401-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00402-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00403-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00404-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00405-of-01024": 39,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00406-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00407-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00408-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00409-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00410-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00411-of-01024": 41,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00412-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00413-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00414-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00415-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00416-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00417-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00418-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00419-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00420-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00421-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00422-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00423-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00424-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00425-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00426-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00427-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00428-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00429-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00430-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00431-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00432-of-01024": 42,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00433-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00434-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00435-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00436-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00437-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00438-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00439-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00440-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00441-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00442-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00443-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00444-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00445-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00446-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00447-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00448-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00449-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00450-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00451-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00452-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00453-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00454-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00455-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00456-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00457-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00458-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00459-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00460-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00461-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00462-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00463-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00464-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00465-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00466-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00467-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00468-of-01024": 19,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00469-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00470-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00471-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00472-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00473-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00474-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00475-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00476-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00477-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00478-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00479-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00480-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00481-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00482-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00483-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00484-of-01024": 39,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00485-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00486-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00487-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00488-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00489-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00490-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00491-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00492-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00493-of-01024": 41,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00494-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00495-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00496-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00497-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00498-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00499-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00500-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00501-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00502-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00503-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00504-of-01024": 40,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00505-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00506-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00507-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00508-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00509-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00510-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00511-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00512-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00513-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00514-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00515-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00516-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00517-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00518-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00519-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00520-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00521-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00522-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00523-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00524-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00525-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00526-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00527-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00528-of-01024": 19,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00529-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00530-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00531-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00532-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00533-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00534-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00535-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00536-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00537-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00538-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00539-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00540-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00541-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00542-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00543-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00544-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00545-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00546-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00547-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00548-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00549-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00550-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00551-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00552-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00553-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00554-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00555-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00556-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00557-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00558-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00559-of-01024": 16,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00560-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00561-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00562-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00563-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00564-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00565-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00566-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00567-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00568-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00569-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00570-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00571-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00572-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00573-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00574-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00575-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00576-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00577-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00578-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00579-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00580-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00581-of-01024": 41,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00582-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00583-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00584-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00585-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00586-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00587-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00588-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00589-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00590-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00591-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00592-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00593-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00594-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00595-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00596-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00597-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00598-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00599-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00600-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00601-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00602-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00603-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00604-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00605-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00606-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00607-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00608-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00609-of-01024": 19,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00610-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00611-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00612-of-01024": 40,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00613-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00614-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00615-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00616-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00617-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00618-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00619-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00620-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00621-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00622-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00623-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00624-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00625-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00626-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00627-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00628-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00629-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00630-of-01024": 19,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00631-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00632-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00633-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00634-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00635-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00636-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00637-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00638-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00639-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00640-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00641-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00642-of-01024": 39,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00643-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00644-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00645-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00646-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00647-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00648-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00649-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00650-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00651-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00652-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00653-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00654-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00655-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00656-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00657-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00658-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00659-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00660-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00661-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00662-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00663-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00664-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00665-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00666-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00667-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00668-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00669-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00670-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00671-of-01024": 39,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00672-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00673-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00674-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00675-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00676-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00677-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00678-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00679-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00680-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00681-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00682-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00683-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00684-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00685-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00686-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00687-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00688-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00689-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00690-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00691-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00692-of-01024": 19,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00693-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00694-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00695-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00696-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00697-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00698-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00699-of-01024": 39,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00700-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00701-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00702-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00703-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00704-of-01024": 17,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00705-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00706-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00707-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00708-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00709-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00710-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00711-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00712-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00713-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00714-of-01024": 19,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00715-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00716-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00717-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00718-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00719-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00720-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00721-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00722-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00723-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00724-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00725-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00726-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00727-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00728-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00729-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00730-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00731-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00732-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00733-of-01024": 43,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00734-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00735-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00736-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00737-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00738-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00739-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00740-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00741-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00742-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00743-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00744-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00745-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00746-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00747-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00748-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00749-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00750-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00751-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00752-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00753-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00754-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00755-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00756-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00757-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00758-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00759-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00760-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00761-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00762-of-01024": 44,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00763-of-01024": 19,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00764-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00765-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00766-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00767-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00768-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00769-of-01024": 39,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00770-of-01024": 40,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00771-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00772-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00773-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00774-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00775-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00776-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00777-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00778-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00779-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00780-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00781-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00782-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00783-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00784-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00785-of-01024": 39,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00786-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00787-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00788-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00789-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00790-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00791-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00792-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00793-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00794-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00795-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00796-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00797-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00798-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00799-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00800-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00801-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00802-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00803-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00804-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00805-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00806-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00807-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00808-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00809-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00810-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00811-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00812-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00813-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00814-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00815-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00816-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00817-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00818-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00819-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00820-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00821-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00822-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00823-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00824-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00825-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00826-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00827-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00828-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00829-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00830-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00831-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00832-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00833-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00834-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00835-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00836-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00837-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00838-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00839-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00840-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00841-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00842-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00843-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00844-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00845-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00846-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00847-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00848-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00849-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00850-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00851-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00852-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00853-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00854-of-01024": 42,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00855-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00856-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00857-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00858-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00859-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00860-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00861-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00862-of-01024": 44,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00863-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00864-of-01024": 52,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00865-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00866-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00867-of-01024": 18,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00868-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00869-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00870-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00871-of-01024": 42,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00872-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00873-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00874-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00875-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00876-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00877-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00878-of-01024": 39,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00879-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00880-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00881-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00882-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00883-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00884-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00885-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00886-of-01024": 19,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00887-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00888-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00889-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00890-of-01024": 18,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00891-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00892-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00893-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00894-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00895-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00896-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00897-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00898-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00899-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00900-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00901-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00902-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00903-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00904-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00905-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00906-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00907-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00908-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00909-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00910-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00911-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00912-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00913-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00914-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00915-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00916-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00917-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00918-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00919-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00920-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00921-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00922-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00923-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00924-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00925-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00926-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00927-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00928-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00929-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00930-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00931-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00932-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00933-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00934-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00935-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00936-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00937-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00938-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00939-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00940-of-01024": 21,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00941-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00942-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00943-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00944-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00945-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00946-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00947-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00948-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00949-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00950-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00951-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00952-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00953-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00954-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00955-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00956-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00957-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00958-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00959-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00960-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00961-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00962-of-01024": 39,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00963-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00964-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00965-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00966-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00967-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00968-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00969-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00970-of-01024": 23,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00971-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00972-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00973-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00974-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00975-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00976-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00977-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00978-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00979-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00980-of-01024": 42,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00981-of-01024": 20,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00982-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00983-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00984-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00985-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00986-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00987-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00988-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00989-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00990-of-01024": 32,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00991-of-01024": 33,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00992-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00993-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00994-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00995-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00996-of-01024": 26,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00997-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00998-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-00999-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01000-of-01024": 41,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01001-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01002-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01003-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01004-of-01024": 37,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01005-of-01024": 16,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01006-of-01024": 34,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01007-of-01024": 17,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01008-of-01024": 38,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01009-of-01024": 31,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01010-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01011-of-01024": 43,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01012-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01013-of-01024": 28,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01014-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01015-of-01024": 25,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01016-of-01024": 22,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01017-of-01024": 30,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01018-of-01024": 36,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01019-of-01024": 27,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01020-of-01024": 24,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01021-of-01024": 29,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01022-of-01024": 35,
    "maniskill_dataset_converted_externally_to_rlds_0.1.0/0.1.0/maniskill_dataset_converted_externally_to_rlds-train.tfrecord-01023-of-01024": 25,
    "nyu_rot_dataset_converted_externally_to_rlds_0.1.0/0.1.0/nyu_rot_dataset_converted_externally_to_rlds-train.tfrecord-00000-of-00001": 14,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00000-of-00060": 9,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00001-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00002-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00003-of-00060": 1,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00004-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00005-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00006-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00007-of-00060": 4,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00008-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00009-of-00060": 5,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00010-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00011-of-00060": 8,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00012-of-00060": 1,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00013-of-00060": 5,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00014-of-00060": 6,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00015-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00016-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00017-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00018-of-00060": 4,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00019-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00020-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00021-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00022-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00023-of-00060": 4,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00024-of-00060": 1,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00025-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00026-of-00060": 1,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00027-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00028-of-00060": 8,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00029-of-00060": 1,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00030-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00031-of-00060": 1,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00032-of-00060": 5,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00033-of-00060": 5,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00034-of-00060": 5,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00035-of-00060": 7,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00036-of-00060": 1,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00037-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00038-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00039-of-00060": 5,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00040-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00041-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00042-of-00060": 4,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00043-of-00060": 5,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00044-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00045-of-00060": 4,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00046-of-00060": 5,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00047-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00048-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00049-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00050-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00051-of-00060": 4,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00052-of-00060": 7,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00053-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00054-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00055-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00056-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00057-of-00060": 2,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00058-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-test.tfrecord-00059-of-00060": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00000-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00001-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00002-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00003-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00004-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00005-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00006-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00007-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00008-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00009-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00010-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00011-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00012-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00013-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00014-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00015-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00016-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00017-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00018-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00019-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00020-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00021-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00022-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00023-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00024-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00025-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00026-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00027-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00028-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00029-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00030-of-00494": 8,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00031-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00032-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00033-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00034-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00035-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00036-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00037-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00038-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00039-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00040-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00041-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00042-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00043-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00044-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00045-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00046-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00047-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00048-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00049-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00050-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00051-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00052-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00053-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00054-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00055-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00056-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00057-of-00494": 8,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00058-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00059-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00060-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00061-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00062-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00063-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00064-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00065-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00066-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00067-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00068-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00069-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00070-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00071-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00072-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00073-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00074-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00075-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00076-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00077-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00078-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00079-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00080-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00081-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00082-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00083-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00084-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00085-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00086-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00087-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00088-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00089-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00090-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00091-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00092-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00093-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00094-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00095-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00096-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00097-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00098-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00099-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00100-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00101-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00102-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00103-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00104-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00105-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00106-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00107-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00108-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00109-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00110-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00111-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00112-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00113-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00114-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00115-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00116-of-00494": 8,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00117-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00118-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00119-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00120-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00121-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00122-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00123-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00124-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00125-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00126-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00127-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00128-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00129-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00130-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00131-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00132-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00133-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00134-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00135-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00136-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00137-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00138-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00139-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00140-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00141-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00142-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00143-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00144-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00145-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00146-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00147-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00148-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00149-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00150-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00151-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00152-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00153-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00154-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00155-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00156-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00157-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00158-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00159-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00160-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00161-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00162-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00163-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00164-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00165-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00166-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00167-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00168-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00169-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00170-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00171-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00172-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00173-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00174-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00175-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00176-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00177-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00178-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00179-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00180-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00181-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00182-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00183-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00184-of-00494": 8,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00185-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00186-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00187-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00188-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00189-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00190-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00191-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00192-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00193-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00194-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00195-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00196-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00197-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00198-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00199-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00200-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00201-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00202-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00203-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00204-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00205-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00206-of-00494": 10,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00207-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00208-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00209-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00210-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00211-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00212-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00213-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00214-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00215-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00216-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00217-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00218-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00219-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00220-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00221-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00222-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00223-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00224-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00225-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00226-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00227-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00228-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00229-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00230-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00231-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00232-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00233-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00234-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00235-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00236-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00237-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00238-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00239-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00240-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00241-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00242-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00243-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00244-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00245-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00246-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00247-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00248-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00249-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00250-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00251-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00252-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00253-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00254-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00255-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00256-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00257-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00258-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00259-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00260-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00261-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00262-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00263-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00264-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00265-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00266-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00267-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00268-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00269-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00270-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00271-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00272-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00273-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00274-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00275-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00276-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00277-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00278-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00279-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00280-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00281-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00282-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00283-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00284-of-00494": 8,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00285-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00286-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00287-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00288-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00289-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00290-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00291-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00292-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00293-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00294-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00295-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00296-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00297-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00298-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00299-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00300-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00301-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00302-of-00494": 8,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00303-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00304-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00305-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00306-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00307-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00308-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00309-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00310-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00311-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00312-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00313-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00314-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00315-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00316-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00317-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00318-of-00494": 9,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00319-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00320-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00321-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00322-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00323-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00324-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00325-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00326-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00327-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00328-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00329-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00330-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00331-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00332-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00333-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00334-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00335-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00336-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00337-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00338-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00339-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00340-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00341-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00342-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00343-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00344-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00345-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00346-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00347-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00348-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00349-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00350-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00351-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00352-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00353-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00354-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00355-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00356-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00357-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00358-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00359-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00360-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00361-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00362-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00363-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00364-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00365-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00366-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00367-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00368-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00369-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00370-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00371-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00372-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00373-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00374-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00375-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00376-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00377-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00378-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00379-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00380-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00381-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00382-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00383-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00384-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00385-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00386-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00387-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00388-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00389-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00390-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00391-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00392-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00393-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00394-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00395-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00396-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00397-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00398-of-00494": 9,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00399-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00400-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00401-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00402-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00403-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00404-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00405-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00406-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00407-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00408-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00409-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00410-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00411-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00412-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00413-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00414-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00415-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00416-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00417-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00418-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00419-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00420-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00421-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00422-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00423-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00424-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00425-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00426-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00427-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00428-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00429-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00430-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00431-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00432-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00433-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00434-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00435-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00436-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00437-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00438-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00439-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00440-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00441-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00442-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00443-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00444-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00445-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00446-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00447-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00448-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00449-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00450-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00451-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00452-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00453-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00454-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00455-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00456-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00457-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00458-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00459-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00460-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00461-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00462-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00463-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00464-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00465-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00466-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00467-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00468-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00469-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00470-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00471-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00472-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00473-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00474-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00475-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00476-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00477-of-00494": 7,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00478-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00479-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00480-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00481-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00482-of-00494": 4,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00483-of-00494": 8,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00484-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00485-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00486-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00487-of-00494": 6,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00488-of-00494": 2,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00489-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00490-of-00494": 5,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00491-of-00494": 3,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00492-of-00494": 1,
    "roboturk_0.1.0/0.1.0/roboturk-train.tfrecord-00493-of-00494": 4,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00000-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00001-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00002-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00003-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00004-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00005-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00006-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00007-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00008-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00009-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00010-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00011-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00012-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00013-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00014-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00015-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00016-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00017-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00018-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00019-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00020-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00021-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00022-of-00350": 5,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00023-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00024-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00025-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00026-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00027-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00028-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00029-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00030-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00031-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00032-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00033-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00034-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00035-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00036-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00037-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00038-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00039-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00040-of-00350": 4,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00041-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00042-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00043-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00044-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00045-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00046-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00047-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00048-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00049-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00050-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00051-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00052-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00053-of-00350": 5,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00054-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00055-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00056-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00057-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00058-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00059-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00060-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00061-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00062-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00063-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00064-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00065-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00066-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00067-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00068-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00069-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00070-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00071-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00072-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00073-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00074-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00075-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00076-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00077-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00078-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00079-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00080-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00081-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00082-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00083-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00084-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00085-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00086-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00087-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00088-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00089-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00090-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00091-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00092-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00093-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00094-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00095-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00096-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00097-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00098-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00099-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00100-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00101-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00102-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00103-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00104-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00105-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00106-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00107-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00108-of-00350": 4,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00109-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00110-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00111-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00112-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00113-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00114-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00115-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00116-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00117-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00118-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00119-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00120-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00121-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00122-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00123-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00124-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00125-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00126-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00127-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00128-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00129-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00130-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00131-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00132-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00133-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00134-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00135-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00136-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00137-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00138-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00139-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00140-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00141-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00142-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00143-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00144-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00145-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00146-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00147-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00148-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00149-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00150-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00151-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00152-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00153-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00154-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00155-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00156-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00157-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00158-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00159-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00160-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00161-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00162-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00163-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00164-of-00350": 4,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00165-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00166-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00167-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00168-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00169-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00170-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00171-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00172-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00173-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00174-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00175-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00176-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00177-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00178-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00179-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00180-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00181-of-00350": 5,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00182-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00183-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00184-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00185-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00186-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00187-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00188-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00189-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00190-of-00350": 4,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00191-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00192-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00193-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00194-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00195-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00196-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00197-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00198-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00199-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00200-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00201-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00202-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00203-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00204-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00205-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00206-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00207-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00208-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00209-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00210-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00211-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00212-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00213-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00214-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00215-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00216-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00217-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00218-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00219-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00220-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00221-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00222-of-00350": 6,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00223-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00224-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00225-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00226-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00227-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00228-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00229-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00230-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00231-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00232-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00233-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00234-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00235-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00236-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00237-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00238-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00239-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00240-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00241-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00242-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00243-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00244-of-00350": 4,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00245-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00246-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00247-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00248-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00249-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00250-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00251-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00252-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00253-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00254-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00255-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00256-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00257-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00258-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00259-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00260-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00261-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00262-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00263-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00264-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00265-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00266-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00267-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00268-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00269-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00270-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00271-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00272-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00273-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00274-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00275-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00276-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00277-of-00350": 4,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00278-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00279-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00280-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00281-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00282-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00283-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00284-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00285-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00286-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00287-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00288-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00289-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00290-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00291-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00292-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00293-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00294-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00295-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00296-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00297-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00298-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00299-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00300-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00301-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00302-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00303-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00304-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00305-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00306-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00307-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00308-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00309-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00310-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00311-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00312-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00313-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00314-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00315-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00316-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00317-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00318-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00319-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00320-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00321-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00322-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00323-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00324-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00325-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00326-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00327-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00328-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00329-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00330-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00331-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00332-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00333-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00334-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00335-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00336-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00337-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00338-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00339-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00340-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00341-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00342-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00343-of-00350": 2,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00344-of-00350": 4,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00345-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00346-of-00350": 3,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00347-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00348-of-00350": 1,
    "stanford_hydra_dataset_converted_externally_to_rlds_0.1.0/0.1.0/stanford_hydra_dataset_converted_externally_to_rlds-train.tfrecord-00349-of-00350": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00000-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00001-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00002-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00003-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00004-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00005-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00006-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00007-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00008-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00009-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00010-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00011-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00012-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00013-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00014-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00015-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00016-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00017-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00018-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00019-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00020-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00021-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00022-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00023-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00024-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00025-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00026-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00027-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00028-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00029-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00030-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00031-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00032-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00033-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00034-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00035-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00036-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00037-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00038-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00039-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00040-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00041-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00042-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00043-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00044-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00045-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00046-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00047-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00048-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00049-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00050-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00051-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00052-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00053-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00054-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00055-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00056-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00057-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00058-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00059-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00060-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00061-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00062-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00063-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00064-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00065-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00066-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00067-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00068-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00069-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00070-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00071-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00072-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00073-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00074-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00075-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00076-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00077-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00078-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00079-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00080-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00081-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00082-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00083-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00084-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00085-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00086-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00087-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00088-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00089-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00090-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00091-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00092-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00093-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00094-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00095-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00096-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00097-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00098-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00099-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00100-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00101-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00102-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00103-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00104-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00105-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00106-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00107-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00108-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00109-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00110-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00111-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00112-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00113-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00114-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00115-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00116-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00117-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00118-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00119-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00120-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00121-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00122-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00123-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00124-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00125-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00126-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00127-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00128-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00129-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00130-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00131-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00132-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00133-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00134-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00135-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00136-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00137-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00138-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00139-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00140-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00141-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00142-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00143-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00144-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00145-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00146-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00147-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00148-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00149-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00150-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00151-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00152-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00153-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00154-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00155-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00156-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00157-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00158-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00159-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00160-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00161-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00162-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00163-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00164-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00165-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00166-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00167-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00168-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00169-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00170-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00171-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00172-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00173-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00174-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00175-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00176-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00177-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00178-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00179-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00180-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00181-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00182-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00183-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00184-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00185-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00186-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00187-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00188-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00189-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00190-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00191-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00192-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00193-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00194-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00195-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00196-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00197-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00198-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00199-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00200-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00201-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00202-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00203-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00204-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00205-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00206-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00207-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00208-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00209-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00210-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00211-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00212-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00213-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00214-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00215-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00216-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00217-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00218-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00219-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00220-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00221-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00222-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00223-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00224-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00225-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00226-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00227-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00228-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00229-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00230-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00231-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00232-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00233-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00234-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00235-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00236-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00237-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00238-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00239-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00240-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00241-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00242-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00243-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00244-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00245-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00246-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00247-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00248-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00249-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00250-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00251-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00252-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00253-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00254-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00255-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00256-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00257-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00258-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00259-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00260-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00261-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00262-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00263-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00264-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00265-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00266-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00267-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00268-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00269-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00270-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00271-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00272-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00273-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00274-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00275-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00276-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00277-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00278-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00279-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00280-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00281-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00282-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00283-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00284-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00285-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00286-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00287-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00288-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00289-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00290-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00291-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00292-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00293-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00294-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00295-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00296-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00297-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00298-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00299-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00300-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00301-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00302-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00303-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00304-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00305-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00306-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00307-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00308-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00309-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00310-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00311-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00312-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00313-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00314-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00315-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00316-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00317-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00318-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00319-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00320-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00321-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00322-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00323-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00324-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00325-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00326-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00327-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00328-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00329-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00330-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00331-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00332-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00333-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00334-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00335-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00336-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00337-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00338-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00339-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00340-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00341-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00342-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00343-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00344-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00345-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00346-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00347-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00348-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00349-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00350-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00351-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00352-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00353-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00354-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00355-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00356-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00357-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00358-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00359-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00360-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00361-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00362-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00363-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00364-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00365-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00366-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00367-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00368-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00369-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00370-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00371-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00372-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00373-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00374-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00375-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00376-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00377-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00378-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00379-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00380-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00381-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00382-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00383-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00384-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00385-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00386-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00387-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00388-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00389-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00390-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00391-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00392-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00393-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00394-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00395-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00396-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00397-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00398-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00399-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00400-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00401-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00402-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00403-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00404-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00405-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00406-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00407-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00408-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00409-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00410-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00411-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00412-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00413-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00414-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00415-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00416-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00417-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00418-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00419-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00420-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00421-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00422-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00423-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00424-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00425-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00426-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00427-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00428-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00429-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00430-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00431-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00432-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00433-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00434-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00435-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00436-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00437-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00438-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00439-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00440-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00441-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00442-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00443-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00444-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00445-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00446-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00447-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00448-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00449-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00450-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00451-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00452-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00453-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00454-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00455-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00456-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00457-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00458-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00459-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00460-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00461-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00462-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00463-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00464-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00465-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00466-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00467-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00468-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00469-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00470-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00471-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00472-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00473-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00474-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00475-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00476-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00477-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00478-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00479-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00480-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00481-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00482-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00483-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00484-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00485-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00486-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00487-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00488-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00489-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00490-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00491-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00492-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00493-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00494-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00495-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00496-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00497-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00498-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00499-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00500-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00501-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00502-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00503-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00504-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00505-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00506-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00507-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00508-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00509-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00510-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00511-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00512-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00513-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00514-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00515-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00516-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00517-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00518-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00519-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00520-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00521-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00522-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00523-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00524-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00525-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00526-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00527-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00528-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00529-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00530-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00531-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00532-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00533-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00534-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00535-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00536-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00537-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00538-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00539-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00540-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00541-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00542-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00543-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00544-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00545-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00546-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00547-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00548-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00549-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00550-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00551-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00552-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00553-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00554-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00555-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00556-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00557-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00558-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00559-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00560-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00561-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00562-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00563-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00564-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00565-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00566-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00567-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00568-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00569-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00570-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00571-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00572-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00573-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00574-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00575-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00576-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00577-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00578-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00579-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00580-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00581-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00582-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00583-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00584-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00585-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00586-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00587-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00588-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00589-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00590-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00591-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00592-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00593-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00594-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00595-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00596-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00597-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00598-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00599-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00600-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00601-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00602-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00603-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00604-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00605-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00606-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00607-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00608-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00609-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00610-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00611-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00612-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00613-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00614-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00615-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00616-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00617-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00618-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00619-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00620-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00621-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00622-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00623-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00624-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00625-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00626-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00627-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00628-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00629-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00630-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00631-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00632-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00633-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00634-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00635-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00636-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00637-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00638-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00639-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00640-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00641-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00642-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00643-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00644-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00645-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00646-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00647-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00648-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00649-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00650-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00651-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00652-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00653-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00654-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00655-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00656-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00657-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00658-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00659-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00660-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00661-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00662-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00663-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00664-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00665-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00666-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00667-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00668-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00669-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00670-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00671-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00672-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00673-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00674-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00675-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00676-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00677-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00678-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00679-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00680-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00681-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00682-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00683-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00684-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00685-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00686-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00687-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00688-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00689-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00690-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00691-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00692-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00693-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00694-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00695-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00696-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00697-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00698-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00699-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00700-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00701-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00702-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00703-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00704-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00705-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00706-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00707-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00708-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00709-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00710-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00711-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00712-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00713-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00714-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00715-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00716-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00717-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00718-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00719-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00720-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00721-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00722-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00723-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00724-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00725-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00726-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00727-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00728-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00729-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00730-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00731-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00732-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00733-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00734-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00735-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00736-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00737-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00738-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00739-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00740-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00741-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00742-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00743-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00744-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00745-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00746-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00747-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00748-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00749-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00750-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00751-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00752-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00753-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00754-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00755-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00756-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00757-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00758-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00759-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00760-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00761-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00762-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00763-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00764-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00765-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00766-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00767-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00768-of-00923": 7,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00769-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00770-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00771-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00772-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00773-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00774-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00775-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00776-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00777-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00778-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00779-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00780-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00781-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00782-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00783-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00784-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00785-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00786-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00787-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00788-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00789-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00790-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00791-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00792-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00793-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00794-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00795-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00796-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00797-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00798-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00799-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00800-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00801-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00802-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00803-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00804-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00805-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00806-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00807-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00808-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00809-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00810-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00811-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00812-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00813-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00814-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00815-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00816-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00817-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00818-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00819-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00820-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00821-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00822-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00823-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00824-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00825-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00826-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00827-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00828-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00829-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00830-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00831-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00832-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00833-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00834-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00835-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00836-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00837-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00838-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00839-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00840-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00841-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00842-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00843-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00844-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00845-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00846-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00847-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00848-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00849-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00850-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00851-of-00923": 8,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00852-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00853-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00854-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00855-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00856-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00857-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00858-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00859-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00860-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00861-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00862-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00863-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00864-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00865-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00866-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00867-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00868-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00869-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00870-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00871-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00872-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00873-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00874-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00875-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00876-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00877-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00878-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00879-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00880-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00881-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00882-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00883-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00884-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00885-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00886-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00887-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00888-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00889-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00890-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00891-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00892-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00893-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00894-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00895-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00896-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00897-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00898-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00899-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00900-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00901-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00902-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00903-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00904-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00905-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00906-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00907-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00908-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00909-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00910-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00911-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00912-of-00923": 4,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00913-of-00923": 6,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00914-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00915-of-00923": 3,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00916-of-00923": 1,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00917-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00918-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00919-of-00923": 5,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00920-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00921-of-00923": 2,
    "stanford_robocook_converted_externally_to_rlds_0.1.0/0.1.0/stanford_robocook_converted_externally_to_rlds-train.tfrecord-00922-of-00923": 1,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00000-of-00064": 8,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00001-of-00064": 6,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00002-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00003-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00004-of-00064": 8,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00005-of-00064": 2,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00006-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00007-of-00064": 8,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00008-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00009-of-00064": 7,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00010-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00011-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00012-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00013-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00014-of-00064": 6,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00015-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00016-of-00064": 8,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00017-of-00064": 7,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00018-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00019-of-00064": 6,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00020-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00021-of-00064": 8,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00022-of-00064": 7,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00023-of-00064": 6,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00024-of-00064": 7,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00025-of-00064": 7,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00026-of-00064": 7,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00027-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00028-of-00064": 6,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00029-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00030-of-00064": 7,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00031-of-00064": 3,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00032-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00033-of-00064": 8,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00034-of-00064": 3,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00035-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00036-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00037-of-00064": 7,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00038-of-00064": 3,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00039-of-00064": 10,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00040-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00041-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00042-of-00064": 9,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00043-of-00064": 3,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00044-of-00064": 9,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00045-of-00064": 9,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00046-of-00064": 7,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00047-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00048-of-00064": 9,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00049-of-00064": 6,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00050-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00051-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00052-of-00064": 1,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00053-of-00064": 7,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00054-of-00064": 2,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00055-of-00064": 6,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00056-of-00064": 8,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00057-of-00064": 5,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00058-of-00064": 2,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00059-of-00064": 7,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00060-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00061-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00062-of-00064": 8,
    "taco_play_0.1.0/0.1.0/taco_play-test.tfrecord-00063-of-00064": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00000-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00001-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00002-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00003-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00004-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00005-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00006-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00007-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00008-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00009-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00010-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00011-of-00511": 12,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00012-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00013-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00014-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00015-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00016-of-00511": 12,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00017-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00018-of-00511": 12,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00019-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00020-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00021-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00022-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00023-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00024-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00025-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00026-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00027-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00028-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00029-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00030-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00031-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00032-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00033-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00034-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00035-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00036-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00037-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00038-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00039-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00040-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00041-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00042-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00043-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00044-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00045-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00046-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00047-of-00511": 12,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00048-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00049-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00050-of-00511": 11,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00051-of-00511": 11,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00052-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00053-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00054-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00055-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00056-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00057-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00058-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00059-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00060-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00061-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00062-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00063-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00064-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00065-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00066-of-00511": 12,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00067-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00068-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00069-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00070-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00071-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00072-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00073-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00074-of-00511": 13,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00075-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00076-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00077-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00078-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00079-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00080-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00081-of-00511": 12,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00082-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00083-of-00511": 13,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00084-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00085-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00086-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00087-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00088-of-00511": 15,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00089-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00090-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00091-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00092-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00093-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00094-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00095-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00096-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00097-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00098-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00099-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00100-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00101-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00102-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00103-of-00511": 1,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00104-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00105-of-00511": 13,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00106-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00107-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00108-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00109-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00110-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00111-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00112-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00113-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00114-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00115-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00116-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00117-of-00511": 1,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00118-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00119-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00120-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00121-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00122-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00123-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00124-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00125-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00126-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00127-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00128-of-00511": 12,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00129-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00130-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00131-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00132-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00133-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00134-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00135-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00136-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00137-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00138-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00139-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00140-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00141-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00142-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00143-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00144-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00145-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00146-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00147-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00148-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00149-of-00511": 1,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00150-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00151-of-00511": 12,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00152-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00153-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00154-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00155-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00156-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00157-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00158-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00159-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00160-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00161-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00162-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00163-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00164-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00165-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00166-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00167-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00168-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00169-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00170-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00171-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00172-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00173-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00174-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00175-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00176-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00177-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00178-of-00511": 11,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00179-of-00511": 11,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00180-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00181-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00182-of-00511": 1,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00183-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00184-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00185-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00186-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00187-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00188-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00189-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00190-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00191-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00192-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00193-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00194-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00195-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00196-of-00511": 1,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00197-of-00511": 11,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00198-of-00511": 13,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00199-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00200-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00201-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00202-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00203-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00204-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00205-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00206-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00207-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00208-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00209-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00210-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00211-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00212-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00213-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00214-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00215-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00216-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00217-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00218-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00219-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00220-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00221-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00222-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00223-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00224-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00225-of-00511": 11,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00226-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00227-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00228-of-00511": 16,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00229-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00230-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00231-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00232-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00233-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00234-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00235-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00236-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00237-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00238-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00239-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00240-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00241-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00242-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00243-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00244-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00245-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00246-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00247-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00248-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00249-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00250-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00251-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00252-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00253-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00254-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00255-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00256-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00257-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00258-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00259-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00260-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00261-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00262-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00263-of-00511": 13,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00264-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00265-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00266-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00267-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00268-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00269-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00270-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00271-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00272-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00273-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00274-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00275-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00276-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00277-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00278-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00279-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00280-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00281-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00282-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00283-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00284-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00285-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00286-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00287-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00288-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00289-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00290-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00291-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00292-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00293-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00294-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00295-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00296-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00297-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00298-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00299-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00300-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00301-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00302-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00303-of-00511": 11,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00304-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00305-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00306-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00307-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00308-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00309-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00310-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00311-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00312-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00313-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00314-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00315-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00316-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00317-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00318-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00319-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00320-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00321-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00322-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00323-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00324-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00325-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00326-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00327-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00328-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00329-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00330-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00331-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00332-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00333-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00334-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00335-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00336-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00337-of-00511": 11,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00338-of-00511": 13,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00339-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00340-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00341-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00342-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00343-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00344-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00345-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00346-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00347-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00348-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00349-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00350-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00351-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00352-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00353-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00354-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00355-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00356-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00357-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00358-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00359-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00360-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00361-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00362-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00363-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00364-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00365-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00366-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00367-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00368-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00369-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00370-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00371-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00372-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00373-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00374-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00375-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00376-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00377-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00378-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00379-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00380-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00381-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00382-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00383-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00384-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00385-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00386-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00387-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00388-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00389-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00390-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00391-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00392-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00393-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00394-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00395-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00396-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00397-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00398-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00399-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00400-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00401-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00402-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00403-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00404-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00405-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00406-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00407-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00408-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00409-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00410-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00411-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00412-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00413-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00414-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00415-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00416-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00417-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00418-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00419-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00420-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00421-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00422-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00423-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00424-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00425-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00426-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00427-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00428-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00429-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00430-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00431-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00432-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00433-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00434-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00435-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00436-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00437-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00438-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00439-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00440-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00441-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00442-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00443-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00444-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00445-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00446-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00447-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00448-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00449-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00450-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00451-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00452-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00453-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00454-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00455-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00456-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00457-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00458-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00459-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00460-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00461-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00462-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00463-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00464-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00465-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00466-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00467-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00468-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00469-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00470-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00471-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00472-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00473-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00474-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00475-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00476-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00477-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00478-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00479-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00480-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00481-of-00511": 13,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00482-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00483-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00484-of-00511": 2,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00485-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00486-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00487-of-00511": 11,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00488-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00489-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00490-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00491-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00492-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00493-of-00511": 3,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00494-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00495-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00496-of-00511": 10,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00497-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00498-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00499-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00500-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00501-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00502-of-00511": 9,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00503-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00504-of-00511": 1,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00505-of-00511": 4,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00506-of-00511": 6,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00507-of-00511": 7,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00508-of-00511": 5,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00509-of-00511": 8,
    "taco_play_0.1.0/0.1.0/taco_play-train.tfrecord-00510-of-00511": 4,
    "tokyo_u_lsmo_converted_externally_to_rlds_0.1.0/0.1.0/tokyo_u_lsmo_converted_externally_to_rlds-train.tfrecord-00000-of-00004": 11,
    "tokyo_u_lsmo_converted_externally_to_rlds_0.1.0/0.1.0/tokyo_u_lsmo_converted_externally_to_rlds-train.tfrecord-00001-of-00004": 17,
    "tokyo_u_lsmo_converted_externally_to_rlds_0.1.0/0.1.0/tokyo_u_lsmo_converted_externally_to_rlds-train.tfrecord-00002-of-00004": 12,
    "tokyo_u_lsmo_converted_externally_to_rlds_0.1.0/0.1.0/tokyo_u_lsmo_converted_externally_to_rlds-train.tfrecord-00003-of-00004": 10,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00000-of-00016": 4,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00001-of-00016": 8,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00002-of-00016": 9,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00003-of-00016": 4,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00004-of-00016": 9,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00005-of-00016": 14,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00006-of-00016": 7,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00007-of-00016": 9,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00008-of-00016": 11,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00009-of-00016": 15,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00010-of-00016": 9,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00011-of-00016": 12,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00012-of-00016": 14,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00013-of-00016": 8,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00014-of-00016": 11,
    "ucsd_kitchen_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_kitchen_dataset_converted_externally_to_rlds-train.tfrecord-00015-of-00016": 6,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00000-of-00032": 49,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00001-of-00032": 45,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00002-of-00032": 31,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00003-of-00032": 45,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00004-of-00032": 45,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00005-of-00032": 50,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00006-of-00032": 43,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00007-of-00032": 29,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00008-of-00032": 43,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00009-of-00032": 34,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00010-of-00032": 39,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00011-of-00032": 36,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00012-of-00032": 45,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00013-of-00032": 41,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00014-of-00032": 39,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00015-of-00032": 43,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00016-of-00032": 44,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00017-of-00032": 52,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00018-of-00032": 38,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00019-of-00032": 54,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00020-of-00032": 46,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00021-of-00032": 32,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00022-of-00032": 41,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00023-of-00032": 48,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00024-of-00032": 45,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00025-of-00032": 34,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00026-of-00032": 42,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00027-of-00032": 43,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00028-of-00032": 44,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00029-of-00032": 47,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00030-of-00032": 48,
    "ucsd_pick_and_place_dataset_converted_externally_to_rlds_0.1.0/0.1.0/ucsd_pick_and_place_dataset_converted_externally_to_rlds-train.tfrecord-00031-of-00032": 40,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00000-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00001-of-00256": 1,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00002-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00003-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00004-of-00256": 10,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00005-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00006-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00007-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00008-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00009-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00010-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00011-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00012-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00013-of-00256": 13,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00014-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00015-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00016-of-00256": 12,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00017-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00018-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00019-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00020-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00021-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00022-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00023-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00024-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00025-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00026-of-00256": 12,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00027-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00028-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00029-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00030-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00031-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00032-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00033-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00034-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00035-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00036-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00037-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00038-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00039-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00040-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00041-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00042-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00043-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00044-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00045-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00046-of-00256": 1,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00047-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00048-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00049-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00050-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00051-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00052-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00053-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00054-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00055-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00056-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00057-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00058-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00059-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00060-of-00256": 13,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00061-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00062-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00063-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00064-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00065-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00066-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00067-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00068-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00069-of-00256": 11,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00070-of-00256": 11,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00071-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00072-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00073-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00074-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00075-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00076-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00077-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00078-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00079-of-00256": 13,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00080-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00081-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00082-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00083-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00084-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00085-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00086-of-00256": 10,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00087-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00088-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00089-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00090-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00091-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00092-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00093-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00094-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00095-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00096-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00097-of-00256": 13,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00098-of-00256": 10,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00099-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00100-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00101-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00102-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00103-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00104-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00105-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00106-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00107-of-00256": 10,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00108-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00109-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00110-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00111-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00112-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00113-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00114-of-00256": 10,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00115-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00116-of-00256": 10,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00117-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00118-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00119-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00120-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00121-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00122-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00123-of-00256": 1,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00124-of-00256": 10,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00125-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00126-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00127-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00128-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00129-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00130-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00131-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00132-of-00256": 11,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00133-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00134-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00135-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00136-of-00256": 11,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00137-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00138-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00139-of-00256": 11,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00140-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00141-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00142-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00143-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00144-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00145-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00146-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00147-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00148-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00149-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00150-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00151-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00152-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00153-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00154-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00155-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00156-of-00256": 10,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00157-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00158-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00159-of-00256": 11,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00160-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00161-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00162-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00163-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00164-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00165-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00166-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00167-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00168-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00169-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00170-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00171-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00172-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00173-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00174-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00175-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00176-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00177-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00178-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00179-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00180-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00181-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00182-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00183-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00184-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00185-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00186-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00187-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00188-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00189-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00190-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00191-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00192-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00193-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00194-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00195-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00196-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00197-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00198-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00199-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00200-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00201-of-00256": 10,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00202-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00203-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00204-of-00256": 1,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00205-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00206-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00207-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00208-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00209-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00210-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00211-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00212-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00213-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00214-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00215-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00216-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00217-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00218-of-00256": 10,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00219-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00220-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00221-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00222-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00223-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00224-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00225-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00226-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00227-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00228-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00229-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00230-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00231-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00232-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00233-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00234-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00235-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00236-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00237-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00238-of-00256": 10,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00239-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00240-of-00256": 5,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00241-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00242-of-00256": 8,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00243-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00244-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00245-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00246-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00247-of-00256": 9,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00248-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00249-of-00256": 3,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00250-of-00256": 4,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00251-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00252-of-00256": 2,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00253-of-00256": 7,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00254-of-00256": 6,
    "utaustin_mutex_0.1.0/0.1.0/utaustin_mutex-train.tfrecord-00255-of-00256": 9,
    "utokyo_saytap_converted_externally_to_rlds_0.1.0/0.1.0/utokyo_saytap_converted_externally_to_rlds-train.tfrecord-00000-of-00001": 20,
    "viola_0.1.0/0.1.0/viola-test.tfrecord-00000-of-00007": 2,
    "viola_0.1.0/0.1.0/viola-test.tfrecord-00001-of-00007": 2,
    "viola_0.1.0/0.1.0/viola-test.tfrecord-00002-of-00007": 1,
    "viola_0.1.0/0.1.0/viola-test.tfrecord-00003-of-00007": 1,
    "viola_0.1.0/0.1.0/viola-test.tfrecord-00004-of-00007": 1,
    "viola_0.1.0/0.1.0/viola-test.tfrecord-00005-of-00007": 3,
    "viola_0.1.0/0.1.0/viola-test.tfrecord-00006-of-00007": 5,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00000-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00001-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00002-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00003-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00004-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00005-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00006-of-00081": 3,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00007-of-00081": 3,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00008-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00009-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00010-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00011-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00012-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00013-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00014-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00015-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00016-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00017-of-00081": 3,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00018-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00019-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00020-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00021-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00022-of-00081": 5,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00023-of-00081": 3,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00024-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00025-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00026-of-00081": 3,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00027-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00028-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00029-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00030-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00031-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00032-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00033-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00034-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00035-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00036-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00037-of-00081": 3,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00038-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00039-of-00081": 4,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00040-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00041-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00042-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00043-of-00081": 3,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00044-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00045-of-00081": 4,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00046-of-00081": 3,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00047-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00048-of-00081": 4,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00049-of-00081": 3,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00050-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00051-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00052-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00053-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00054-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00055-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00056-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00057-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00058-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00059-of-00081": 3,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00060-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00061-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00062-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00063-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00064-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00065-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00066-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00067-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00068-of-00081": 4,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00069-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00070-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00071-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00072-of-00081": 3,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00073-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00074-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00075-of-00081": 2,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00076-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00077-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00078-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00079-of-00081": 1,
    "viola_0.1.0/0.1.0/viola-train.tfrecord-00080-of-00081": 1,
}
