# Code for On the Convergence of No-Regret Dynamics in Information Retrieval Games with Proportional Ranking Functions

## Getting Started

First, make sure you are located in the `code` directory:

```
code
├── README.md
├── main_simulations.ipynb
├── hyperparameters_simulations.ipynb
├── regret_calculations.ipynb
├── softmax_simulations.ipynb
├── distribution_simulations.ipynb
├── requirements.txt
├── utils
├── figures
├── results
```

Next, use `pip` to install project requirements:

```
pip install -r requirements.txt
```

## Running the Notebooks

Now, you may launch the JupyterLab interface by running the `jupyter lab` command, and interact with each of the following notebooks:

- `main_simulations.ipynb`: the main game parameters simulations for Section 5.1 of the paper.
- `hyperparameters_simulations.ipynb`: the hyperparameters simulations for Section 5.2 of the paper.
- `regret_calculations.ipynb`: regret calculations with game parameters and hyperparameters comparisons for Appendices B.1 of the paper.
- `softmax_simulations.ipynb`: regret over time example with the sotmax ranking function for Appendices B.2 of the paper, and some extra softmax simulations which are not included in the paper.
- `distribution_simulations.ipynb`: comparison of diffrent $x_0$ and $x^*$ normal distributions for Appendices B.3 of the paper.

## Additional Directories

The `utils` directory contains the source code for the notebooks. <br>
The `figures` directory contains the figures generated by the notebooks. <br>
The `results` directory contains the numerical results of simulations generated by the notebooks. 
