import numpy as np

# Random seed
SEED = 0

# Math parameters
DELTA_ = 1e-5

# Tags and Types
PROPORTIONAL = 'Proportional'
LINEAR_PROPORTIONAL, ROOT_PROPORTIONAL, LOG_PROPORTIONAL = 'Linear', 'Root', 'Logarithmic'
SOFTMAX = 'Exponential'  # 'Softmax'

INTERCEPT_VALS = [1 + DELTA_] + list(range(2, 11))
POWER_VALS = np.round(np.arange(0.1, 1, 0.1), 1)
SHIFT_VALS = [2 + DELTA_] + list(range(3, 11))
BETA_VALS_ = np.concatenate([np.arange(0.5, 2.1, 0.5), np.array([3]), np.arange(5, 10.1, 5)])

INTERCEPT_STR = r'Intercept hyperparameter $b$'
POWER_STR = r'Power hyperparameter $a$'
SHIFT_STR = r'Shift hyperparameter $c$'
BETA_STR = r'Inverse temperature hyperparameter $\beta$'

# Game parameters
K_STR = r'$k$'
N_STR = r'$n$'
S_STR = r'$s$'
LAM_STR = r'$\lambda$'
K_VALS_ = [5, 10, 15, 20, 25]
N_VALS_ = range(2, 11)
S_VALS_ = list(range(1, 5)) + list(range(5, 51, 5))
LAM_VALS_ = np.round(np.arange(0.05, 1.01, 0.05), 2)
BASE_K = 3
BASE_N = 3
BASE_S = 3
BASE_LAM = 0.5

# Simulation parameters
B_ = 500
ETA_REGRET_ = 0.5
T_REGRET_ = 10000
T_REGRET_CALC_ = 100
EPS_REGRET_ = 1e-4

# Saving parameters
SAVE_PATH = 'results'
FIGURES_PATH = 'figures'
CALC_REGRET_SUFFIX = '_calc'

# Plotting parameters
PROPORTIONAL_COLORS = {LINEAR_PROPORTIONAL: '#ff7f0e', ROOT_PROPORTIONAL: '#1f77b4', LOG_PROPORTIONAL: '#2ca02c',
                       SOFTMAX: '#000000'}

PUBLISHERS_WELFARE = "Publishers' Welfare"
USERS_WELFARE = "Users' Welfare"
CONVERGENCE_RATE = 'Convergence Rate'
CONVERGENCE_RATIO = 'Convergence Ratio'
AVG_REGRET = 'Average Regret'


EXTENDED_CONVERGENCE_RATE = 'Extended Convergence Rate'
EXTENDED_AVG_REGRET = 'Extended Average Regret'

AUTO = 'auto'
ALL = 'all'

AXIS_LIMITS = {PUBLISHERS_WELFARE: [0.969, 1.001], USERS_WELFARE: [0.83, 0.95], CONVERGENCE_RATE: [0, 1050],
               CONVERGENCE_RATIO: [0, 1.1], EXTENDED_CONVERGENCE_RATE: [0, 2600], 
               AVG_REGRET: [0.0175, 0.0275], EXTENDED_AVG_REGRET: [0, 0.0325]}

AXIS_TICKS = {PUBLISHERS_WELFARE: np.arange(0.97, 1.00001, 0.005), USERS_WELFARE: np.arange(0.84, 0.941, 0.02),
              CONVERGENCE_RATE: range(100, 1001, 100), EXTENDED_CONVERGENCE_RATE: range(250, 2501, 250), 
              AVG_REGRET: np.arange(0.018, 0.0275, 0.001), EXTENDED_AVG_REGRET: np.arange(0.005, 0.0325, 0.005),
              CONVERGENCE_RATIO: np.arange(0, 1.1, 0.1)}

LABELS_FONT_SIZE = 19  # 18
TICKS_FONT_SIZE = 16  # 14
LEGEND_FONT_SIZE = 15  # 13

# Default functions
k_key_function = lambda k, n, s, lam: k
n_key_function = lambda k, n, s, lam: n
s_key_function = lambda k, n, s, lam: s
lam_key_function = lambda k, n, s, lam: lam

ranking_function_label_function = lambda name: name.strip('.pkl').strip('.csv').split('_')[0]
additional_param_label_function = lambda name: name.strip('.pkl').strip('.csv').split('_')[1]

proportional_ranking_function_sort_key = lambda x: 0 if x == LINEAR_PROPORTIONAL else \
    (1 if x == ROOT_PROPORTIONAL else 2)  # log is last
float_sort_key = lambda x: float(x)
