# PUUPL
Positive-Unlabeled Learning with Uncertainty-aware Pseudo-label Selection

## Quick Start

 1. Installation (in development mode)

     ```
     conda env create -n puupl --file environment.yaml
     conda activate puupl
     pip install -e .
     ```

 2. Launch training

     ```
     pucu-train [/path/to/config.yaml] [override:value]
     ```

     Check the `configs` folder to see what experiments are available.

 3. Monitor training and check results

     ```
     mlflow ui
     ```

## Ablation studies

See folder `ablations`.

## Framework overview

The source code is in `src/pucu`. Important things to know:
 - The training loop is based on Pytorch Lightning, in `experiments.py`
 - Each step of the pseudo-labeling outer loop is handled in `validation_epoch_end`
 - The pseudo-labeling logic is in `lib/pseudolabel.py`
 - The neural networks that are trained are in `lib/architectures.py`
 - The datasets are in `lib/data.py`
 - The nnPU loss is in `lib/losses.py`
