Ablation studies
===

# Automatic generation of ablation studies

There is a python script that will read a given configuration and modify certain
parameters to run interesting ablation studies

```
python ablations/make-ablations.py ablations/base-ens.yaml
```

This will create new configurations in the configs folder, overwriting existing ones.
After you run this script, do not forget to re-generate the Snakefile:

```
python ablations/make-snakefile.py --skip-existing
```

# How to run the ablations

From the root folder:

```
bash ablations/run-ablations.sh
```

# How to add new ablation experiments

 1. Create a new yaml file in the configs folder with the configuration to run
    - Either manually or by modifying the `make-ablations.py` script
 2. (from the root folder) run `python ablations/make-snakefile.py`
    - This will create a new Snakefile that includes the configuration just added
 3. Run the ablation studies again with the bash script above (only new ones will be run)

