set -ex

if (( $# != 3 )); then
    echo "Usage: $0 <config> <output> <job name>"
    exit -1
fi

HOST=`hostname`
if [ "$HOST" == "vicb-submit-02.scidom.de" ]; then
    PART=gpu_p
    QOS=gpu
elif [ "$HOST" == "datalab2" ]; then
    PART=dgx-a100
    QOS=mcml
else
    echo "No configuration for host $HOST"
    exit -2
fi

srun -p $PART --gres=gpu:1 --qos=$QOS -J $3 --cpus-per-task 6 --mem 48G \
	pucu-train $1 pl_iterations:15 > $2 2>&1
ec=$!
echo "Exited with code $ec"

if (( $ec != 0 )); then
    echo "Copying logs file to safe location"
    mkdir -p dev/failed-jobs
    cp $2 dev/failed-jobs/$(basename $2)
fi

exit $ec
