# Fisale

Fisale: Neural Latent Arbitrary Lagrangian-Eulerian Grids for Fluid-Solid Interaction

Code submission to ICLR 2026.

# Usage

## Create Data and Assets Filefolders

Filefolders should follow the structure:

```
root_folder/
├── structure_oscillation/
│   ├── assets/
|   |   ├──checkpoints             # save model weight
|   |   ├──logs                    # save training and test logs
|   |   └──normalizers             # save normalizers
│   └── data/          
|       ├──input                   # dataset
|       └──ret                     # prediction results
├── venous_valve/
│   ├── assets/
|   |   ├──checkpoints   
|   |   ├──logs          
|   |   └──normalizers   
│   └── data/
|       ├──input         
|       └──ret           
└── flexible_wing/
   ├── assets/
   |   ├──checkpoints   
   |   ├──logs          
   |   └──normalizers  
   └── data/
       ├──input        
       └──ret           
```

## Dataset

The structure oscillation dataset can be found in [CoDA-NO repo](https://github.com/neuraloperator/CoDA-NO)

We will open the dataset of venous valve and flexible wing if the paper is accepted.


## Install dependencies

1. recommend `python 3.10`, `torch 2.5.0`
2. install `torch_geometric` follow the [official repo](https://github.com/pyg-team/pytorch_geometric)
3. other dependencies: `h5py`, `einops`, `toml`


## Train, eval and test the model

```
# run structure oscillation task
setsid python -u exp_structure_oscillation.py & 

# run venous valve task
setsid python -u exp_venous_valve.py &

# run flexible wing task
setsid python -u exp_flexible_wing.py &
```