"""initial

Revision ID: 436d019ad85e
Revises:
Create Date: 2025-01-09 14:34:47.653420

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "436d019ad85e"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "datasets",
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("num_features", sa.Integer(), nullable=False),
        sa.Column("num_classes", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("dataset_id"),
        sa.UniqueConstraint("name"),
    )
    op.create_table(
        "graphs",
        sa.Column("graph_id", sa.Integer(), nullable=False),
        sa.Column("index", sa.Integer(), nullable=True),
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.Column("label", sa.JSON(), nullable=False),
        sa.ForeignKeyConstraint(
            ["dataset_id"],
            ["datasets.dataset_id"],
        ),
        sa.PrimaryKeyConstraint("graph_id"),
        sa.UniqueConstraint("dataset_id", "index"),
    )
    op.create_table(
        "geds",
        sa.Column("ged_id", sa.Integer(), nullable=False),
        sa.Column("graph_0_id", sa.Integer(), nullable=True),
        sa.Column("graph_1_id", sa.Integer(), nullable=True),
        sa.Column("value", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["graph_0_id"],
            ["graphs.graph_id"],
        ),
        sa.ForeignKeyConstraint(
            ["graph_1_id"],
            ["graphs.graph_id"],
        ),
        sa.PrimaryKeyConstraint("ged_id"),
        sa.UniqueConstraint("graph_0_id", "graph_1_id"),
    )
    op.create_table(
        "mixup_attrs",
        sa.Column("mixup_attr_id", sa.Integer(), nullable=False),
        sa.Column("graph_id", sa.Integer(), nullable=False),
        sa.Column("parent_0_id", sa.Integer(), nullable=False),
        sa.Column("parent_1_id", sa.Integer(), nullable=False),
        sa.Column("mixup_lambda", sa.Float(), nullable=False),
        sa.Column("mixup_method", sa.String(length=255), nullable=False),
        sa.Column("mixup_hyperparameters", sa.JSON(), nullable=True),
        sa.ForeignKeyConstraint(
            ["graph_id"],
            ["graphs.graph_id"],
        ),
        sa.ForeignKeyConstraint(
            ["parent_0_id"],
            ["graphs.graph_id"],
        ),
        sa.ForeignKeyConstraint(
            ["parent_1_id"],
            ["graphs.graph_id"],
        ),
        sa.PrimaryKeyConstraint("mixup_attr_id"),
        sa.UniqueConstraint("graph_id"),
    )
    op.create_table(
        "nodes",
        sa.Column("node_id", sa.Integer(), nullable=False),
        sa.Column("graph_id", sa.Integer(), nullable=False),
        sa.Column("index", sa.Integer(), nullable=False),
        sa.Column("attributes", sa.JSON(), nullable=True),
        sa.ForeignKeyConstraint(
            ["graph_id"],
            ["graphs.graph_id"],
        ),
        sa.PrimaryKeyConstraint("node_id"),
        sa.UniqueConstraint("graph_id", "index"),
    )
    op.create_table(
        "edges",
        sa.Column("edge_id", sa.Integer(), nullable=False),
        sa.Column("graph_id", sa.Integer(), nullable=False),
        sa.Column("node_0_id", sa.Integer(), nullable=False),
        sa.Column("node_1_id", sa.Integer(), nullable=False),
        sa.Column("index", sa.Integer(), nullable=False),
        sa.Column("attributes", sa.JSON(), nullable=True),
        sa.CheckConstraint(
            "node_0_id < node_1_id", name="node_0_id_less_than_node_1_id"
        ),
        sa.ForeignKeyConstraint(
            ["graph_id"],
            ["graphs.graph_id"],
        ),
        sa.ForeignKeyConstraint(
            ["node_0_id"],
            ["nodes.node_id"],
        ),
        sa.ForeignKeyConstraint(
            ["node_1_id"],
            ["nodes.node_id"],
        ),
        sa.PrimaryKeyConstraint("edge_id"),
        sa.UniqueConstraint("graph_id", "index"),
        sa.UniqueConstraint("graph_id", "node_0_id", "node_1_id"),
    )
    op.create_table(
        "mappings",
        sa.Column("mapping_id", sa.Integer(), nullable=False),
        sa.Column("ged_id", sa.Integer(), nullable=False),
        sa.Column("node_0_id", sa.Integer(), nullable=False),
        sa.Column("node_1_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["ged_id"],
            ["geds.ged_id"],
        ),
        sa.ForeignKeyConstraint(
            ["node_0_id"],
            ["nodes.node_id"],
        ),
        sa.ForeignKeyConstraint(
            ["node_1_id"],
            ["nodes.node_id"],
        ),
        sa.PrimaryKeyConstraint("mapping_id"),
        sa.UniqueConstraint("ged_id", "node_0_id"),
        sa.UniqueConstraint("ged_id", "node_1_id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("mappings")
    op.drop_table("edges")
    op.drop_table("nodes")
    op.drop_table("mixup_attrs")
    op.drop_table("geds")
    op.drop_table("graphs")
    op.drop_table("datasets")
    # ### end Alembic commands ###
