# ATTracker

## Installation

1. Create and activate a conda environment

```shell
cd ${ATTracker_ROOT}
```

(torch 2.0.0):
```shell
conda create -n mpt python=3.8
pip install -r requirements.txt
```


## Data Preparation
1. Download TNL2K, OTB99 and LaSOT

2. Put the tracking datasets in ./data. It should look like (or use ```ln -s .../src/... .../dst/... ``` to creat soft link):  

```
${ATTracker_ROOT}

-- code

-- data
    -- lasot
        -- zip
            |-- airplane
            |-- basketball
            ...
    -- otb99
        -- OTB_query_test
            |-- Biker.txt
            |-- Bird1.txt
            ...
        -- OTB_query_train
            |-- Basketball.txt
            |-- Bolt.txt
            ...
        -- OTB_videos
            |-- Basketball
            |-- Biker
            ...
    -- tnl2k
        -- TNL2K_test_subset
            -- absent
                |-- advSamp_Baseball_game_002-Done.txt
                |-- advSamp_Baseball_video_01-Done.txt
                ...
            -- TNL2K_test_subset_p1
                |-- test_001_BatMan_video_06
                |-- test_002_BF5_FireGUN_video_05
                ...
            ...
            -- TNL2K_test_subset_p7
            -- handle.sh
        -- TNL2K_train_subset
            -- Arrow_Video_ZZ04_done
            ...
            -- ZhuoQiu_video_07-Done
            -- handle.sh

-- experiments

-- pretrained
    -- bert-base-uncased
        -- config.json
        -- pytorch_model.bin
        -- vocab.txt
    -- mae_pretrain_vit_base.pth

-- README.md

-- requirements.txt

```

## Train
1. Modify wandb settings for log and visualization (i.e., WANDB_API_KEY, wandb.init)

2. Train the model



``` shell
cd code/

# (torch 2.0.0)
CUDA_VISIBLE_DEVICES=1,2 torchrun --nproc-per-node=2 --master_port=12345 main.py --cfg ltr/config/v0.yaml

or

# (torch 1.11.0)
CUDA_VISIBLE_DEVICES=1,2 torchrun --nproc_per_node=2 --master_port=12345 main.py --cfg ltr/config/v0.yaml
```

3. Resume training (modify the config file by replacing the resume with latest checkpoint's path)

``` shell
CUDA_VISIBLE_DEVICES=1,2 torchrun --nproc-per-node=2 --master_port=12345 main.py --cfg ltr/config/v0.yaml
```

## Test
0. Modify line 49 in ${ATTracker_ROOT}/code/ltr/models/tracker/sttracker.py

1. Test one checkpoint of one epoch
```shell

CUDA_VISIBLE_DEVICES=5 torchrun test_multi.py --test_model ${ATTracker_ROOT}/experiments/ATTracker_lasot,otb99,tnl2k/exp1/checkpoints/model_epoch_180.bin --threads 1 --data tnl2k

```

2. Test multiple checkpoints
```shell
# modify test.sh to suit your situation
sh test.sh
```


## Evaluation
1. The result of the OTB99 dataset is reported in the test log   
(e.g.,```${ATTracker_ROOT}/experiments/ATTracker_lasot,otb99,tnl2k/exp1/test/model_epoch_168.bin/otb99.log```)

2. TNL2K and LaSOT datasets both contain videos that do not have any target as the **Adversarial Samples**, therefore to prevent inflated score and accurately evaluate the model:

    2.1 We use ```eval.py``` to evaluate the model on LaSOT
    ```shell
    python eval.py --tracker_path ${ATTracker_ROOT}/experiments/ATTracker_lasot,otb99,tnl2k/exp2/test/ --dataset lasot --tracker_prefix model_epoch_194.bin
    ```

    2.2 We move the raw reuslts from the exp path (e.g.,```${ATTracker_ROOT}/experiments/ATTracker_lasot,otb99,tnl2k/exp1/test/model_epoch_168.bin/tnl2k```) to the [TNL2K Evaluation Toolkit](https://github.com/wangxiao5791509/TNL2K_evaluation_toolkit) to perform evaluation


## Contact

## Acknowledgments
This is a combination version of the python tracking framework [PyTracking](https://github.com/visionml/pytracking) and [PySOT-Toolkit](https://github.com/StrangerZhang/pysot-toolkit).


## Citation

If our work is useful for your research, please consider cite:
```

```


