import argparse


def parse_args():
    parser = argparse.ArgumentParser(description="SATracker")

    parser.add_argument('--cfg', type=str, default='ltr/config/v0.yaml', help='yaml configure file name')
    parser.add_argument('--version', type=str, default='', help='version')
    parser.add_argument('--test_model', type=str, default='', help='model to test')

    parser.add_argument('--threads', type=int, default='6', help='threads to test')
    parser.add_argument('--gpus', type=int, default=1, help='num of gpus')
    parser.add_argument('--data', type=str, default='otb99', help='data to test')
    parser.add_argument('--length', type=int, default=-1, help='length')
    parser.add_argument('--begin', type=int, default=0, help='begin of the dataset')
    parser.add_argument('--end', type=int, default=-1, help='end of the datset')
    args = parser.parse_args()

    return args
    