import os
import json
import numpy as np

from tqdm import tqdm
from glob import glob

from .dataset import Dataset
from .video import Video

class TNL2KVideo(Video):
    """
    Args:
        name: video name
        root: dataset root
        video_dir: video directory
        init_rect: init rectangle
        img_names: image names
        gt_rect: groundtruth rectangle
        attr: attribute of video
    """
    def __init__(self, dataset_name, name, root, video_dir, init_rect, img_names,
            gt_rect, attr=None, absent=None, load_img=False):
        super(TNL2KVideo, self).__init__(dataset_name, name, root, video_dir,
                init_rect, img_names, gt_rect, attr, load_img)
        self.absent = np.array(absent, np.int8)

    def load_tracker(self, path, tracker_names=None, store=True):
        """
        Args:
            path(str): path to result
            tracker_name(list): name of tracker
        """
        if not tracker_names:
            tracker_names = [x.split('/')[-1] for x in glob(path)
                    if os.path.isdir(x)]
        if isinstance(tracker_names, str):
            tracker_names = [tracker_names]

        for name in tracker_names:
            traj_file = os.path.join(path, name, self.dataset_name, self.name+'.txt')
            # traj_file = os.path.join(path, self.dataset_name, self.name+'.txt')
            if os.path.exists(traj_file):
                with open(traj_file, 'r') as f :
                    pred_traj = [list(map(float, x.strip().split(',')))
                            for x in f.readlines()]
            else:
                print("File not exists: ", traj_file)
                pred_traj = []
            if store:
                self.pred_trajs[name] = pred_traj
            else:
                return pred_traj
        self.tracker_names = list(self.pred_trajs.keys())



class TNL2KDataset(Dataset):
    """
    Args:
        name: dataset name, should be 'OTB100', 'CVPR13', 'OTB50'
        dataset_root: dataset root
        load_img: wether to load all imgs
    """
    def __init__(self, name, dataset_root, load_img=False):
        super(TNL2KDataset, self).__init__(name, dataset_root)
        with open(os.path.join(dataset_root, name+'.json'), 'r') as f:
            meta_data = json.load(f)

        # load videos
        pbar = tqdm(meta_data.keys(), desc='loading '+name, ncols=100)
        self.videos = {}
        for video in pbar:
            pbar.set_postfix_str(video)
            self.videos[video] = TNL2KVideo(name.lower(),
                                          video,
                                          dataset_root,
                                          meta_data[video]['video_dir'],
                                          meta_data[video]['init_rect'],
                                          meta_data[video]['img_names'],
                                          meta_data[video]['gt_rect'],
                                          meta_data[video]['attr'],
                                          meta_data[video]['absent'])

        # set attr
        # attr = []
        # for x in self.videos.values():
        #     attr += x.attr
        # attr = set(attr)
        # self.attr = {}
        # self.attr['ALL'] = list(self.videos.keys())
        # for x in attr:
        #     self.attr[x] = []
        # for k, v in self.videos.items():
        #     for attr_ in v.attr:
        #         self.attr[attr_].append(k)


