<p align="center">
  <img src="resource/logo.png" alt="Project HR2R Logo" width="150"/>
</p>

## HR2R: Hidden Roads to Roam

A research-oriented Recurrent Transformer for hierarchical, iterative reasoning. Includes training, inference, and unified evaluation utilities.

### Installation

- Requires Python >= 3.10
- Using a virtual environment is recommended

```bash
pip install -e .
# optional: training/acceleration extras
pip install -e .[training]
```

### Quick start

- Inference example

```bash
python script/playground/inference_example.py
```

- Minimal SFT training example

```bash
python script/playground/training_example.py
# or inspect the full training script options
python script/train/SFT_HR2R.py --help
```

- Data preparation (dialog-style JSON/JSONL)

```bash
python script/data/slm_convert.py --help
python script/data/slm_prefill.py --help
```

- Evaluation

```bash
python script/evaluate/eval.py --help
```

### Repository structure

- `hr2r/`: core library (`model/`, `train/`, `evaluate/`, `utils/`)
- `script/`: scripts (`playground/`, `train/`, `data/`, `evaluate/`, `analysis/`)
- `resource/`: assets (e.g., `logo.png`)
- helper shells: `sft_hr2r.sh`, `eval_hr2r.sh`, `pre_data.sh`, etc.

### Dependencies

- Core: `torch`, `transformers`
- Optional training: `deepspeed`, `accelerate`, `flash-attn`, `wandb`, etc.
- See `pyproject.toml` for full listings

### License

MIT License
