# DeepFIB



## Dataset

We conduct the experiments on **4** time-series datasets, namely **2d-gesture, Power demand, ECG and Credit Card**.


## Get started

### Requirements

Install the required package first:

```
cd DeepFIB
conda create -n deepfib python=3.8
conda activate deepfib
pip install -r requirements.txt
```

### Dataset preparation

The data directory structure is shown as follows. 
```
./
└── data/
    ├── credit
    │    └── Credit.csv
    │── ecg
    │    ├── labeled
    │    └── raw
    │── gesture
    │    ├── labeled
    │    └── raw
    └── power_demand
         ├── labeled
         └── raw
```

### Run testing

We provide the code for reproducibility of our experimental results.


#### For 2d-gesture:

```
python InferGesture.py 
```


#### For ECG:
You can replace the dataset name to see each result.

```
python InferECG.py --dataset chfdb_chf13_45590
```


#### For Power-demand:
```
python run_power_demand.py  
```

#### For Credit Card:

```
python run_credit.py  
``` 

