## $M^3$-IRT
This repository contains the code and data for the paper "Evaluating Cross-Modal Reasoning Ability and Problem Charactaristics with Multimodal Item Response Theory".
### Preparation
Install [rye](https://rye.astral.sh/guide/installation/).
Use rye to specify and install the Python version.
You can install python libraries with the following command.
```bash
rye sync
```

### Experiments

Before starting the experiments, create a result folder to store csv files.

```bash
mkdir result
```

#### CAT Experiment
If you want to run CAT experiments with $M^3$-IRT, you can use the following command:
```bash
rye run python src/mmirt/experiments/cat/mfi_mshuffle.py --asplit {--mathvista, --vqa, --seedbench} --N {Up to 999 for mathvista and seedbench, up to 1000 for vqa, up to 900 for mmmu}
```
If you want to run CAT experiments with $M^2$-IRT, you can use the following command:
```bash
rye run python src/mmirt/experiments/cat/m2irt_shuffle.py --fisher {--mathvista, --vqa, --seedbench} --N {Up to 999 for mathvista and seedbench, up to 1000 for vqa, up to 900 for mmmu}
```
### AUC

```bash
rye run python src/mmirt/experiments/auc_shuffle.py {--asplit, --nosplit} {--mathvista, --vqa, --seedbench}
```

You can perform the same AUC experiments as described in the paper by running the script as follows:

```bash
chmod 755 scripts/auc_shuffle.sh
./scripts/auc_shuffle.sh
```

### Others

The data is stored in mmmu\_normal\_shuffle, vqa\_shuffle\_normal, seed\_normal\_shuffled,and merged\_mathvista.
